export const BREAKDOWN_WORDS = [
	'Czech',
	'Boston',
	'Geoff',
	'St.',
	'Senate',
	'Interior',
	'convention',
	'de',
]

/**
 * First dimension is prevTag, second dimension is word, indexed by:
 *
 * prevTag = [
 *   'B-ORG','I-ORG','B-PER','I-PER',
 *   'B-LOC','I-LOC','B-MISC','I-MISC','O']
 *
 * words = [
 *   "Czech","Boston","Geoff","St.",
 *   "Senate","Interior","convention", "de"];
 *
 */
export const BREAKDOWNS = [
	[
		{
			features: {
				'I-ORG': [
					{ feature: 'shape=Xxxxx', tag: 'I-ORG', value: 1, weight: 0.312 },
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'word=emerged', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=braves', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'word=posted', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Media', tag: 'I-ORG', weight: 0.453, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.238 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.954 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'word=Navy', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=is', tag: 'O', weight: 0.496, value: 0 },
					{ feature: 'lowercase=lubin', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=1:53.993', tag: 'O', weight: 0.486, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -1.027 },
					{ feature: 'word=emerged', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=Navy', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=is', tag: 'O', weight: 0.496, value: 0 },
					{ feature: 'lowercase=lubin', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=1:53.993', tag: 'O', weight: 0.486, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.186 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'word=emerged', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=Navy', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=is', tag: 'O', weight: 0.496, value: 0 },
					{ feature: 'lowercase=lubin', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=1:53.993', tag: 'O', weight: 0.486, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -1.409 },
					{ feature: 'shape=Xxxxx', tag: 'B-PER', value: 1, weight: -0.321 },
					{ feature: 'word=emerged', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=Navy', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=is', tag: 'O', weight: 0.496, value: 0 },
					{ feature: 'lowercase=lubin', tag: 'I-ORG', weight: 0.453, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.183 },
					{ feature: 'word=emerged', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=Navy', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=is', tag: 'O', weight: 0.496, value: 0 },
					{ feature: 'lowercase=lubin', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=1:53.993', tag: 'O', weight: 0.486, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.994,
				O: -1.742,
				'B-MISC': -4.406,
				'B-ORG': -4.542,
				'B-PER': -5.764,
				'B-LOC': -10.056,
			},
			z: 2.903,
			probabilities: {
				'I-ORG': 0.931,
				O: 0.06,
				'B-MISC': 0.004,
				'B-ORG': 0.004,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'shape=Xxxxxx', tag: 'I-ORG', value: 1, weight: 0.306 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'word=seven', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Democracy', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Graz', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=braves', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -1.489 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.954 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'lowercase=jugomagnat', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=magazine', tag: 'O', weight: 0.002, value: 0 },
					{ feature: 'lowercase=brooks', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.186 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.068 },
					{ feature: 'word=seven', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=jugomagnat', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=magazine', tag: 'O', weight: 0.002, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -1.027 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: -0.583 },
					{ feature: 'word=seven', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=jugomagnat', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=magazine', tag: 'O', weight: 0.002, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -1.409 },
					{ feature: 'word=seven', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=jugomagnat', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=magazine', tag: 'O', weight: 0.002, value: 0 },
					{ feature: 'lowercase=brooks', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.183 },
					{ feature: 'word=seven', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=jugomagnat', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=magazine', tag: 'O', weight: 0.002, value: 0 },
					{ feature: 'lowercase=brooks', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.988,
				O: -1.993,
				'B-ORG': -4.474,
				'B-MISC': -4.989,
				'B-PER': -5.444,
				'B-LOC': -10.056,
			},
			z: 2.845,
			probabilities: {
				'I-ORG': 0.944,
				O: 0.048,
				'B-ORG': 0.004,
				'B-MISC': 0.002,
				'B-PER': 0.002,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'shape=Xxxxx', tag: 'I-ORG', value: 1, weight: 0.312 },
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'word=predicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=street', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'word=1:51.884', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=Brasov', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.238 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.954 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'lowercase=banka', tag: 'I-ORG', weight: 0.54, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Munich', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'word=trip-Canada', tag: 'B-MISC', weight: 2.094, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -1.027 },
					{ feature: 'word=predicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=banka', tag: 'I-ORG', weight: 0.54, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Munich', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'word=Palace', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.186 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'wordspredicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=banka', tag: 'I-ORG', weight: 0.54, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Munich', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'word=trip-Canada', tag: 'B-MISC', weight: 2.094, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -1.409 },
					{ feature: 'shape=Xxxxx', tag: 'B-PER', value: 1, weight: -0.321 },
					{ feature: 'word=predicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=banka', tag: 'I-ORG', weight: 0.54, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Munich', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.183 },
					{ feature: 'word=predicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=banka', tag: 'I-ORG', weight: 0.54, value: 0 },
					{ feature: 'lowercase=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Munich', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'word=trip-Canada', tag: 'B-MISC', weight: 2.094, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.994,
				O: -1.742,
				'B-MISC': -4.406,
				'B-ORG': -4.542,
				'B-PER': -5.764,
				'B-LOC': -10.056,
			},
			z: 2.903,
			probabilities: {
				'I-ORG': 0.931,
				O: 0.06,
				'B-MISC': 0.004,
				'B-ORG': 0.004,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'word=of', tag: 'O', weight: -0.169, value: 0 },
					{ feature: 'lowercase=globo', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'word=railway', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=kamyshin', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'lowercase=12', tag: 'O', weight: 0.441, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.954 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'word=STAR', tag: 'I-ORG', weight: 0.547, value: 0 },
					{ feature: 'lowercase=rockies', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=25.00', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=Soybean', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=0:09', tag: 'O', weight: 0.486, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -1.027 },
					{ feature: 'word=STAR', tag: 'I-ORG', weight: 0.547, value: 0 },
					{ feature: 'word=of', tag: 'O', weight: -0.169, value: 0 },
					{ feature: 'lowercase=globo', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'word=railway', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=kamyshin', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.186 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'word=STAR', tag: 'I-ORG', weight: 0.547, value: 0 },
					{ feature: 'word=of', tag: 'O', weight: -0.169, value: 0 },
					{ feature: 'lowercase=globo', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'word=railway', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=kamyshin', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -1.409 },
					{ feature: 'word=STAR', tag: 'I-ORG', weight: 0.547, value: 0 },
					{ feature: 'word=of', tag: 'O', weight: -0.169, value: 0 },
					{ feature: 'lowercase=globo', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'word=railway', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=kamyshin', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.183 },
					{ feature: 'word=STAR', tag: 'I-ORG', weight: 0.547, value: 0 },
					{ feature: 'word=of', tag: 'O', weight: -0.169, value: 0 },
					{ feature: 'lowercase=globo', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'word=railway', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=kamyshin', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.682,
				O: -0.504,
				'B-MISC': -4.406,
				'B-ORG': -4.542,
				'B-PER': -5.444,
				'B-LOC': -10.056,
			},
			z: 2.609,
			probabilities: {
				'I-ORG': 0.758,
				O: 0.232,
				'B-MISC': 0.005,
				'B-ORG': 0.004,
				'B-PER': 0.002,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'word=Senate', tag: 'I-ORG', value: 1, weight: 0.312 },
					{ feature: 'lowercase=senate', tag: 'I-ORG', value: 1, weight: 0.312 },
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'shape=Xxxxxx', tag: 'I-ORG', value: 1, weight: 0.306 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'word=L', tag: 'O', weight: 0.614, value: 0 },
					{ feature: 'word=starts', tag: 'O', weight: 0.465, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -1.489 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.954 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'word=Nationalist', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'word=30', tag: 'O', weight: 0.441, value: 0 },
					{ feature: 'lowercase=predicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=gathering', tag: 'O', weight: 0.462, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.186 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.068 },
					{ feature: 'word=Nationalist', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'word=L', tag: 'O', weight: 0.614, value: 0 },
					{ feature: 'word=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=predicted', tag: 'O', weight: 0.462, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -1.027 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: -0.583 },
					{ feature: 'word=Nationalist', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'word=L', tag: 'O', weight: 0.614, value: 0 },
					{ feature: 'word=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=predicted', tag: 'O', weight: 0.462, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -1.409 },
					{ feature: 'word=Nationalist', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'word=L', tag: 'O', weight: 0.614, value: 0 },
					{ feature: 'word=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=predicted', tag: 'O', weight: 0.462, value: 0 },
					{ feature: 'lowercase=gathering', tag: 'O', weight: 0.462, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.183 },
					{ feature: 'word=Nationalist', tag: 'I-ORG', weight: 0.474, value: 0 },
					{ feature: 'word=L', tag: 'O', weight: 0.614, value: 0 },
					{ feature: 'word=starts', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Editorial', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=win', tag: 'O', weight: 0.482, value: 0 },
				],
			},
			sums: {
				'I-ORG': 1.612,
				O: -1.993,
				'B-ORG': -4.474,
				'B-MISC': -4.989,
				'B-PER': -5.444,
				'B-LOC': -10.056,
			},
			z: 5.172,
			probabilities: {
				'I-ORG': 0.969,
				O: 0.026,
				'B-ORG': 0.002,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'shape=Xxxxxxxx', tag: 'I-ORG', value: 1, weight: 0.312 },
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'word=38:18.759', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=varazdin', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Caltex', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=tigers', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxxxx', tag: 'O', value: 1, weight: -0.964 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.954 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'lowercase=variety', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=Stuttgart', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'lowercase=names', tag: 'O', weight: 0.182, value: 0 },
					{ feature: 'lowercase=tigers', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.186 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'lowercase=variety', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=38:18.759', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=varazdin', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Caltex', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=tigers', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -1.027 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-MISC', value: 1, weight: -0.534 },
					{ feature: 'lowercase=variety', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=38:18.759', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=varazdin', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Caltex', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -1.409 },
					{ feature: 'lowercase=variety', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=38:18.759', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=varazdin', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Caltex', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=tigers', tag: 'I-ORG', weight: 0.45, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.183 },
					{ feature: 'lowercase=variety', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'word=38:18.759', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'lowercase=varazdin', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Caltex', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=analyst', tag: 'O', weight: 0.486, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.993,
				O: -1.469,
				'B-ORG': -4.542,
				'B-MISC': -4.94,
				'B-PER': -5.444,
				'B-LOC': -10.056,
			},
			z: 2.952,
			probabilities: {
				'I-ORG': 0.914,
				O: 0.078,
				'B-ORG': 0.004,
				'B-MISC': 0.002,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.296 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'word=Brothers', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Weather', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'lowercase=mirren', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=workers', tag: 'I-ORG', weight: 0.41, value: 0 },
				],
				'I-ORG': [
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_title_case', tag: 'I-ORG', value: 1, weight: -0.199 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'lowercase=often', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=wheat', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=farul', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'word=target', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Variety', tag: 'I-ORG', weight: 0.452, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -1.645 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'lowercase=often', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Brothers', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Weather', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'lowercase=mirren', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=workers', tag: 'I-ORG', weight: 0.41, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -3.443 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'lowercase=often', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Brothers', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Weather', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'lowercase=mirren', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=workers', tag: 'I-ORG', weight: 0.41, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_title_case', tag: 'B-PER', value: 1, weight: -3.281 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'lowercase=often', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Brothers', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Weather', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'lowercase=mirren', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=workers', tag: 'I-ORG', weight: 0.41, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'lowercase=often', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Brothers', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Weather', tag: 'I-ORG', weight: 0.452, value: 0 },
					{ feature: 'lowercase=mirren', tag: 'I-ORG', weight: 0.45, value: 0 },
					{ feature: 'lowercase=workers', tag: 'I-ORG', weight: 0.41, value: 0 },
					{ feature: 'is_not_title_case', tag: 'B-MISC', weight: -4.967, value: 0 },
				],
			},
			sums: {
				O: 1.082,
				'I-ORG': 0.172,
				'B-ORG': -5.001,
				'B-MISC': -6.821,
				'B-PER': -7.316,
				'B-LOC': -9.873,
			},
			z: 4.147,
			probabilities: {
				O: 0.711,
				'I-ORG': 0.286,
				'B-ORG': 0.002,
				'B-MISC': 0,
				'B-PER': 0,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'word=de', tag: 'I-ORG', value: 1, weight: 0.413 },
					{ feature: 'lowercase=de', tag: 'I-ORG', value: 1, weight: 0.409 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.215 },
					{ feature: 'is_not_title_case', tag: 'I-ORG', value: 1, weight: -0.199 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.156 },
					{ feature: 'shape=xx', tag: 'I-ORG', value: 1, weight: 0.118 },
					{ feature: 'word=this', tag: 'O', weight: 0.454, value: 0 },
					{ feature: 'word=PTT', tag: 'I-ORG', weight: 0.558, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.296 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.245 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.203 },
					{ feature: 'word=Industry', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=Porto', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'shape=d:dd.ddd', tag: 'O', weight: 0.486, value: 0 },
					{ feature: 'word=gave', tag: 'O', weight: 0.454, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -2.329 },
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -1.645 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.027 },
					{ feature: 'word=Industry', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=this', tag: 'O', weight: 0.454, value: 0 },
					{ feature: 'word=PTT', tag: 'I-ORG', weight: 0.558, value: 0 },
					{ feature: 'word=Unity', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=illinois', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -3.443 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.882 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.497 },
					{ feature: 'word=Industry', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=this', tag: 'O', weight: 0.454, value: 0 },
					{ feature: 'word=PTT', tag: 'I-ORG', weight: 0.558, value: 0 },
					{ feature: 'word=Unity', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=illinois', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_title_case', tag: 'B-PER', value: 1, weight: -3.281 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.248 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -1.787 },
					{ feature: 'word=Industry', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=this', tag: 'O', weight: 0.454, value: 0 },
					{ feature: 'word=PTT', tag: 'I-ORG', weight: 0.558, value: 0 },
					{ feature: 'word=Unity', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=illinois', tag: 'I-ORG', weight: 0.457, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -5.568 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -4.305 },
					{ feature: 'word=Industry', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'word=this', tag: 'O', weight: 0.454, value: 0 },
					{ feature: 'word=PTT', tag: 'I-ORG', weight: 0.558, value: 0 },
					{ feature: 'word=Unity', tag: 'I-ORG', weight: 0.453, value: 0 },
					{ feature: 'lowercase=illinois', tag: 'I-ORG', weight: 0.457, value: 0 },
					{ feature: 'lowercase=governor', tag: 'O', weight: 0.48, value: 0 },
				],
			},
			sums: {
				'I-ORG': 1.112,
				O: 0.99,
				'B-ORG': -5.001,
				'B-MISC': -6.821,
				'B-PER': -7.316,
				'B-LOC': -9.873,
			},
			z: 5.74,
			probabilities: {
				'I-ORG': 0.53,
				O: 0.469,
				'B-ORG': 0.001,
				'B-MISC': 0,
				'B-PER': 0,
				'B-LOC': 0,
			},
		},
	],
	[
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'shape=Xxxxx', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'word=resolution', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=212-859-1610', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'word=their', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=human', tag: 'I-ORG', weight: 0.461, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.108 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.883 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'lowercase=labour', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=NV', tag: 'I-ORG', weight: 0.595, value: 0 },
					{ feature: 'word=coach', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=edged', tag: 'O', weight: 0.463, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'lowercase=labour', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=resolution', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=212-859-1610', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'word=their', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=human', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=tikva', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=novgorod', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.241 },
					{ feature: 'lowercase=labour', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=resolution', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=212-859-1610', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'word=their', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=human', tag: 'I-ORG', weight: 0.461, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.246 },
					{ feature: 'lowercase=labour', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=resolution', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=212-859-1610', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'word=their', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=human', tag: 'I-ORG', weight: 0.461, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.313 },
					{ feature: 'lowercase=labour', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=resolution', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=212-859-1610', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'word=their', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=human', tag: 'I-ORG', weight: 0.461, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.942,
				O: -1.501,
				'B-ORG': -3.549,
				'B-MISC': -6.342,
				'B-PER': -6.349,
				'B-LOC': -8.197,
			},
			z: 2.821,
			probabilities: {
				'I-ORG': 0.909,
				O: 0.079,
				'B-ORG': 0.01,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'shape=Xxxxxx', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'word=guerrillas', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=3-0', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=mets', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=lead', tag: 'O', weight: 0.452, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.883 },
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -0.775 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'lowercase=voorhis', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=school', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=14.12', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=v', tag: 'I-ORG', weight: -0.364, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'word=guerrillas', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=voorhis', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=school', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=14.12', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=v', tag: 'I-ORG', weight: -0.364, value: 0 },
					{ feature: 'lowercase=host', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'lowercase=countries', tag: 'O', weight: 0.479, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 0.721 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.246 },
					{ feature: 'word=guerrillas', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=voorhis', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=school', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=14.12', tag: 'O', weight: 0.479, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: 0.473 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.241 },
					{ feature: 'word=guerrillas', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=voorhis', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=school', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=14.12', tag: 'O', weight: 0.479, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.313 },
					{ feature: 'word=guerrillas', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=voorhis', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=school', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=14.12', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=v', tag: 'I-ORG', weight: -0.364, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.936,
				O: -1.169,
				'B-ORG': -3.549,
				'B-PER': -5.628,
				'B-MISC': -5.869,
				'B-LOC': -8.197,
			},
			z: 2.896,
			probabilities: {
				'I-ORG': 0.88,
				O: 0.107,
				'B-ORG': 0.01,
				'B-PER': 0.001,
				'B-MISC': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'shape=Xxxxx', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'word=416', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'lowercase=says', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'word=.', tag: 'O', weight: 0.438, value: 0 },
					{ feature: 'word=Johnson', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.108 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.883 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'word=Tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'lowercase=22', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=after', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=sent', tag: 'O', weight: 0.452, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'is_not_uppercase', tag: 'O', weight: 0.377, value: 0 },
					{ feature: 'word=Tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'lowercase=22', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=after', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=sent', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'lowercase=gmbh', tag: 'I-ORG', weight: 0.567, value: 0 },
					{ feature: 'word=1996-08-22', tag: 'O', weight: 0.479, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.241 },
					{ feature: 'word=Tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=416', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'lowercase=says', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'word=.', tag: 'O', weight: 0.438, value: 0 },
					{ feature: 'word=Johnson', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.246 },
					{ feature: 'word=Tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=416', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'lowercase=says', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'word=.', tag: 'O', weight: 0.438, value: 0 },
					{ feature: 'word=Johnson', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.313 },
					{ feature: 'word=Tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=416', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'lowercase=says', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'word=.', tag: 'O', weight: 0.438, value: 0 },
					{ feature: 'word=Johnson', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.942,
				O: -1.501,
				'B-ORG': -3.549,
				'B-MISC': -6.342,
				'B-PER': -6.349,
				'B-LOC': -8.197,
			},
			z: 2.821,
			probabilities: {
				'I-ORG': 0.909,
				O: 0.079,
				'B-ORG': 0.01,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'lowercase=lezion', tag: 'O', weight: 0.698, value: 0 },
					{ feature: 'word=Dodgers', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'word=Airbus', tag: 'B-MISC', weight: 2.59, value: 0 },
					{ feature: 'word=Telecomm', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Dole', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.883 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'word=Mexico', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=agreed', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'word=Airbus', tag: 'B-MISC', weight: 2.59, value: 0 },
					{ feature: 'word=Telecomm', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Dole', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'lowercase=lezion', tag: 'O', weight: 0.698, value: 0 },
					{ feature: 'word=Mexico', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=agreed', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'word=Airbus', tag: 'B-MISC', weight: 2.59, value: 0 },
					{ feature: 'word=Telecomm', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Dole', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'word=Pool', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.241 },
					{ feature: 'lowercase=lezion', tag: 'O', weight: 0.698, value: 0 },
					{ feature: 'word=Mexico', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=agreed', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=safety', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'word=N', tag: 'I-ORG', weight: 0.477, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.246 },
					{ feature: 'lowercase=lezion', tag: 'O', weight: 0.698, value: 0 },
					{ feature: 'word=Mexico', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=agreed', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'word=Airbus', tag: 'B-MISC', weight: 2.59, value: 0 },
					{ feature: 'word=Telecomm', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.313 },
					{ feature: 'lowercase=lezion', tag: 'O', weight: 0.698, value: 0 },
					{ feature: 'word=Mexico', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=agreed', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'word=Airbus', tag: 'B-MISC', weight: 2.59, value: 0 },
					{ feature: 'word=Telecomm', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.625,
				O: -0.393,
				'B-ORG': -3.549,
				'B-MISC': -6.342,
				'B-PER': -6.349,
				'B-LOC': -8.197,
			},
			z: 2.576,
			probabilities: {
				'I-ORG': 0.725,
				O: 0.262,
				'B-ORG': 0.011,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'shape=Xxxxxx', tag: 'I-ORG', value: 1, weight: 0.311 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'word=demanded', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=interim', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Ireland', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.883 },
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -0.775 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
					{ feature: 'word=ltd', tag: 'O', weight: 0.545, value: 0 },
					{ feature: 'lowercase=motorcycle', tag: 'I-ORG', weight: 0.481, value: 0 },
					{ feature: 'word=Enchaine', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
					{ feature: 'word=demanded', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=interim', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Ireland', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
					{ feature: 'word=batsman', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-LOC', weight: 1.388, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 0.721 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.246 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
					{ feature: 'word=demanded', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=interim', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Ireland', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: 0.473 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.241 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
					{ feature: 'word=demanded', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=interim', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Ireland', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.313 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
					{ feature: 'word=demanded', tag: 'O', weight: 0.463, value: 0 },
					{ feature: 'lowercase=interim', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Ireland', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'shape=.', tag: 'I-ORG', weight: -0.63, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.936,
				O: -1.169,
				'B-ORG': -3.549,
				'B-PER': -5.628,
				'B-MISC': -5.869,
				'B-LOC': -8.197,
			},
			z: 2.896,
			probabilities: {
				'I-ORG': 0.88,
				O: 0.107,
				'B-ORG': 0.01,
				'B-PER': 0.001,
				'B-MISC': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				'I-ORG': [
					{ feature: 'is_title_case', tag: 'I-ORG', value: 1, weight: 0.317 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-ORG', value: 1, weight: 0.314 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'shape=X-XXXXXX', tag: 'O', weight: 0.493, value: 0 },
					{ feature: 'word=striker', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'shape=d', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'lowercase=will', tag: 'O', weight: 0.452, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxxxx', tag: 'O', value: 1, weight: -0.885 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.883 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'word=College', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=54', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=continued', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=corp', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'shape=X-XXXXXX', tag: 'O', weight: 0.493, value: 0 },
					{ feature: 'word=College', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=54', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=continued', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=corp', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'word=Control', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=finland', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.241 },
					{ feature: 'shape=X-XXXXXX', tag: 'O', weight: 0.493, value: 0 },
					{ feature: 'word=College', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=54', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=continued', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=corp', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.246 },
					{ feature: 'shape=X-XXXXXX', tag: 'O', weight: 0.493, value: 0 },
					{ feature: 'word=College', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=54', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=continued', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=corp', tag: 'I-ORG', weight: 0.463, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-LOC', value: 1, weight: 0.962 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.313 },
					{ feature: 'shape=X-XXXXXX', tag: 'O', weight: 0.493, value: 0 },
					{ feature: 'word=College', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=54', tag: 'O', weight: 0.473, value: 0 },
					{ feature: 'word=continued', tag: 'O', weight: 0.479, value: 0 },
				],
			},
			sums: {
				'I-ORG': 0.94,
				O: -1.279,
				'B-ORG': -3.549,
				'B-MISC': -6.342,
				'B-PER': -6.349,
				'B-LOC': -7.235,
			},
			z: 2.871,
			probabilities: {
				'I-ORG': 0.892,
				O: 0.097,
				'B-ORG': 0.01,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.333 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.302 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'is_uppercase', tag: 'I-ORG', weight: 0.384, value: 0 },
					{ feature: 'lowercase=mayer', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=angola', tag: 'I-ORG', weight: 0.562, value: 0 },
					{ feature: 'lowercase=relations', tag: 'I-ORG', weight: 0.471, value: 0 },
				],
				'I-ORG': [
					{ feature: 'lowercase=convention', tag: 'I-ORG', value: 1, weight: 0.334 },
					{ feature: 'is_not_title_case', tag: 'I-ORG', value: 1, weight: -0.326 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'lowercase=striker', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Service', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=plan', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'lowercase=madrid', tag: 'I-ORG', weight: 0.466, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'is_uppercase', tag: 'I-ORG', weight: 0.384, value: 0 },
					{ feature: 'lowercase=striker', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Service', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=plan', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'lowercase=madrid', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=liability', tag: 'O', weight: 0.479, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'is_uppercase', tag: 'I-ORG', weight: 0.384, value: 0 },
					{ feature: 'lowercase=striker', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Service', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=plan', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'lowercase=madrid', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=liability', tag: 'O', weight: 0.479, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -3.044 },
					{ feature: 'is_uppercase', tag: 'I-ORG', weight: 0.384, value: 0 },
					{ feature: 'lowercase=striker', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', weight: -5.541, value: 0 },
					{ feature: 'lowercase=florida', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'word=past', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'word=Management', tag: 'I-ORG', weight: 0.49, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'is_uppercase', tag: 'I-ORG', weight: 0.384, value: 0 },
					{ feature: 'lowercase=striker', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'word=Service', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=plan', tag: 'O', weight: 0.452, value: 0 },
					{ feature: 'lowercase=madrid', tag: 'I-ORG', weight: 0.466, value: 0 },
					{ feature: 'lowercase=liability', tag: 'O', weight: 0.479, value: 0 },
				],
			},
			sums: {
				O: 1.124,
				'I-ORG': 0.316,
				'B-MISC': -6.101,
				'B-PER': -6.103,
				'B-ORG': -6.593,
				'B-LOC': -7.884,
			},
			z: 4.455,
			probabilities: {
				O: 0.691,
				'I-ORG': 0.308,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-ORG': 0,
				'B-LOC': 0,
			},
		},
		{
			features: {
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.302 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.228 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.222 },
					{ feature: 'lowercase=steel', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=workers', tag: 'O', weight: 0.369, value: 0 },
					{ feature: 'lowercase=6-3', tag: 'O', weight: 0.479, value: 0 },
					{ feature: 'lowercase=settlement', tag: 'O', weight: 0.479, value: 0 },
				],
				'I-ORG': [
					{ feature: 'word=de', tag: 'I-ORG', value: 1, weight: 0.425 },
					{ feature: 'lowercase=de', tag: 'I-ORG', value: 1, weight: 0.425 },
					{ feature: 'is_not_title_case', tag: 'I-ORG', value: 1, weight: -0.326 },
					{ feature: 'is_not_digit', tag: 'I-ORG', value: 1, weight: 0.179 },
					{ feature: 'shape=xx', tag: 'I-ORG', value: 1, weight: 0.153 },
					{ feature: 'is_not_uppercase', tag: 'I-ORG', value: 1, weight: 0.129 },
					{ feature: 'lowercase=secured', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=corporation', tag: 'I-ORG', weight: 0.481, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -3.84 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -2.261 },
					{ feature: 'lowercase=steel', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=secured', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=corporation', tag: 'I-ORG', weight: 0.481, value: 0 },
					{ feature: 'lowercase=journal', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Popullit', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -3.841 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -2.262 },
					{ feature: 'lowercase=steel', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=secured', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=corporation', tag: 'I-ORG', weight: 0.481, value: 0 },
					{ feature: 'lowercase=journal', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Popullit', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.549 },
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -3.044 },
					{ feature: 'lowercase=steel', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=secured', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=corporation', tag: 'I-ORG', weight: 0.481, value: 0 },
					{ feature: 'lowercase=journal', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Popullit', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.844 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.04 },
					{ feature: 'lowercase=steel', tag: 'I-ORG', weight: 0.461, value: 0 },
					{ feature: 'lowercase=secured', tag: 'O', weight: 0.465, value: 0 },
					{ feature: 'lowercase=corporation', tag: 'I-ORG', weight: 0.481, value: 0 },
					{ feature: 'lowercase=journal', tag: 'I-ORG', weight: 0.463, value: 0 },
					{ feature: 'lowercase=tribunal', tag: 'I-ORG', weight: 0.464, value: 0 },
					{ feature: 'word=Popullit', tag: 'I-ORG', weight: 0.464, value: 0 },
				],
			},
			sums: {
				O: 1.014,
				'I-ORG': 0.985,
				'B-MISC': -6.101,
				'B-PER': -6.103,
				'B-ORG': -6.593,
				'B-LOC': -7.884,
			},
			z: 5.441,
			probabilities: {
				O: 0.507,
				'I-ORG': 0.492,
				'B-MISC': 0,
				'B-PER': 0,
				'B-ORG': 0,
				'B-LOC': 0,
			},
		},
	],
	[
		{
			features: {
				'I-PER': [
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.244 },
					{ feature: 'shape=Xxxxx', tag: 'I-PER', value: 1, weight: 0.232 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'word=accuses', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=chiesa', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Anglert', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Sion', tag: 'I-PER', weight: 0.343, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.884 },
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.369 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'lowercase=younis', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=77', tag: 'O', weight: 0.59, value: 0 },
					{ feature: 'lowercase=prodi', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'word=Simeonov', tag: 'I-PER', weight: 0.364, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 0.596 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.45 },
					{ feature: 'lowercase=younis', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=accuses', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=chiesa', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Anglert', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'lowercase=younis', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=accuses', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=chiesa', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Anglert', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Sion', tag: 'I-PER', weight: 0.343, value: 0 },
					{ feature: 'lowercase=35', tag: 'O', weight: 0.59, value: 0 },
				],
			},
			sums: { 'I-PER': 0.786, O: -6.997, 'B-LOC': -7.691, 'B-MISC': -8.765 },
			z: 2.196,
			probabilities: { 'I-PER': 0.999, O: 0, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'word=Boston', tag: 'I-PER', value: 1, weight: 0.252 },
					{ feature: 'lowercase=boston', tag: 'I-PER', value: 1, weight: 0.252 },
					{ feature: 'shape=Xxxxxx', tag: 'I-PER', value: 1, weight: 0.252 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.244 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'lowercase=hincza', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=managed', tag: 'O', weight: 0.648, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.884 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'word=Barngetuny', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=managed', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=berger', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Andersson', tag: 'I-PER', weight: 0.365, value: 0 },
					{ feature: 'lowercase=haarhuis', tag: 'I-PER', weight: 0.364, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.45 },
					{ feature: 'word=Barngetuny', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=managed', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=berger', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Andersson', tag: 'I-PER', weight: 0.365, value: 0 },
					{ feature: 'lowercase=haarhuis', tag: 'I-PER', weight: 0.364, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'word=Barngetuny', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=managed', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=berger', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Andersson', tag: 'I-PER', weight: 0.365, value: 0 },
					{ feature: 'lowercase=haarhuis', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=70th', tag: 'O', weight: 0.648, value: 0 },
				],
			},
			sums: { 'I-PER': 1.309, O: -5.629, 'B-LOC': -8.287, 'B-MISC': -8.765 },
			z: 3.706,
			probabilities: { 'I-PER': 0.999, O: 0.001, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.244 },
					{ feature: 'shape=Xxxxx', tag: 'I-PER', value: 1, weight: 0.232 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'lowercase=61st', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=sabotzik', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Remigino', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Jadeja', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.884 },
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.369 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'lowercase=jackiewicz', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=dismissed', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=219', tag: 'O', weight: 0.59, value: 0 },
					{ feature: 'word=Irvine', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 0.596 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.45 },
					{ feature: 'lowercase=jackiewicz', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=61st', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=sabotzik', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Remigino', tag: 'I-PER', weight: 0.364, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'lowercase=jackiewicz', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=61st', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=sabotzik', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Remigino', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Jadeja', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=wouden', tag: 'I-PER', weight: 0.363, value: 0 },
				],
			},
			sums: { 'I-PER': 0.786, O: -6.997, 'B-LOC': -7.691, 'B-MISC': -8.765 },
			z: 2.196,
			probabilities: { 'I-PER': 0.999, O: 0, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.244 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'shape=xxxxxxxxxxxxxx', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Alvarado', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=0:04', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Aziz', tag: 'I-PER', weight: 0.343, value: 0 },
					{ feature: 'word=Maleeva', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.884 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'lowercase=swift', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'lowercase=corretja', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=pescosolido', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Dutroux', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=plavsic', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.45 },
					{ feature: 'lowercase=swift', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'shape=xxxxxxxxxxxxxx', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Alvarado', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=0:04', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Aziz', tag: 'I-PER', weight: 0.343, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'lowercase=swift', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'shape=xxxxxxxxxxxxxx', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Alvarado', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=0:04', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Aziz', tag: 'I-PER', weight: 0.343, value: 0 },
					{ feature: 'word=Maleeva', tag: 'I-PER', weight: 0.363, value: 0 },
				],
			},
			sums: { 'I-PER': 0.554, O: -5.629, 'B-LOC': -8.287, 'B-MISC': -8.765 },
			z: 1.744,
			probabilities: { 'I-PER': 0.998, O: 0.002, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'shape=Xxxxxx', tag: 'I-PER', value: 1, weight: 0.252 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.244 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'lowercase=met', tag: 'O', weight: 0.556, value: 0 },
					{ feature: 'word=Bevan', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'lowercase=coetzee', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=visit', tag: 'O', weight: 0.408, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.884 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'lowercase=abdullah', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Lobinger', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=ntawulikura', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=have', tag: 'O', weight: 0.384, value: 0 },
					{ feature: 'lowercase=57.2', tag: 'O', weight: 0.648, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.45 },
					{ feature: 'lowercase=met', tag: 'O', weight: 0.556, value: 0 },
					{ feature: 'lowercase=abdullah', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Lobinger', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=ntawulikura', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=have', tag: 'O', weight: 0.384, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'lowercase=met', tag: 'O', weight: 0.556, value: 0 },
					{ feature: 'lowercase=abdullah', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Lobinger', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=ntawulikura', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=have', tag: 'O', weight: 0.384, value: 0 },
					{ feature: 'lowercase=57.2', tag: 'O', weight: 0.648, value: 0 },
				],
			},
			sums: { 'I-PER': 0.805, O: -5.629, 'B-LOC': -8.287, 'B-MISC': -8.765 },
			z: 2.241,
			probabilities: { 'I-PER': 0.998, O: 0.002, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'shape=Xxxxxxxx', tag: 'I-PER', value: 1, weight: 0.249 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.244 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'word=Ivar', tag: 'I-PER', weight: 0.343, value: 0 },
					{ feature: 'lowercase=an', tag: 'O', weight: 0.622, value: 0 },
					{ feature: 'lowercase=boulami', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=knaven', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.884 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'word=Qichen', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=patten', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Komarica', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'lowercase=wellman', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=Chiesa', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-LOC', value: 1, weight: 1.357 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.45 },
					{ feature: 'word=Qichen', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=patten', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=an', tag: 'O', weight: 0.622, value: 0 },
					{ feature: 'lowercase=boulami', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'word=Qichen', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=patten', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=an', tag: 'O', weight: 0.622, value: 0 },
					{ feature: 'lowercase=boulami', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=knaven', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=29th', tag: 'O', weight: 0.648, value: 0 },
				],
			},
			sums: { 'I-PER': 0.803, O: -5.629, 'B-LOC': -6.931, 'B-MISC': -8.765 },
			z: 2.237,
			probabilities: { 'I-PER': 0.998, O: 0.002, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.449 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'lowercase=brown', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'lowercase=10.57:33', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'lowercase=third', tag: 'O', weight: 0.408, value: 0 },
					{ feature: 'word=Pushpakumara', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'I-PER': [
					{ feature: 'is_not_title_case', tag: 'I-PER', value: 1, weight: -1.979 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'word=found', tag: 'O', weight: 0.408, value: 0 },
					{ feature: 'word=Vaughan', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=schneider', tag: 'I-PER', weight: 0.365, value: 0 },
					{ feature: 'word=Staunton', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Courier', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'lowercase=brown', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'word=found', tag: 'O', weight: 0.408, value: 0 },
					{ feature: 'word=Vaughan', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=schneider', tag: 'I-PER', weight: 0.365, value: 0 },
					{ feature: 'word=Staunton', tag: 'I-PER', weight: 0.364, value: 0 },
					{ feature: 'word=Courier', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -0.888 },
					{ feature: 'lowercase=brown', tag: 'I-PER', weight: 0.341, value: 0 },
					{ feature: 'word=found', tag: 'O', weight: 0.408, value: 0 },
					{ feature: 'word=Vaughan', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=schneider', tag: 'I-PER', weight: 0.365, value: 0 },
					{ feature: 'word=Staunton', tag: 'I-PER', weight: 0.364, value: 0 },
				],
			},
			sums: { O: 1.02, 'I-PER': -1.669, 'B-LOC': -7.838, 'B-MISC': -9.653 },
			z: 2.962,
			probabilities: { O: 0.936, 'I-PER': 0.064, 'B-LOC': 0, 'B-MISC': 0 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'word=de', tag: 'I-PER', value: 1, weight: 2.108 },
					{ feature: 'is_not_title_case', tag: 'I-PER', value: 1, weight: -1.979 },
					{ feature: 'lowercase=de', tag: 'I-PER', value: 1, weight: 1.57 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: 0.157 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: 0.153 },
					{ feature: 'shape=xx', tag: 'I-PER', value: 1, weight: -0.106 },
					{ feature: 'word=signalled', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Stewart', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.217 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.133 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.123 },
					{ feature: 'word=Auchard', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=17-0-91-0', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Martens', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=zvereva', tag: 'I-PER', weight: 0.363, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.931 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.907 },
					{ feature: 'word=signalled', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Auchard', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=17-0-91-0', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Martens', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=zvereva', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=10-1-36-2', tag: 'O', weight: 0.648, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -4.546 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -4.219 },
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -0.888 },
					{ feature: 'word=signalled', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Auchard', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'word=17-0-91-0', tag: 'O', weight: 0.648, value: 0 },
					{ feature: 'word=Martens', tag: 'I-PER', weight: 0.363, value: 0 },
					{ feature: 'lowercase=zvereva', tag: 'I-PER', weight: 0.363, value: 0 },
				],
			},
			sums: { 'I-PER': 1.903, O: 0.788, 'B-LOC': -7.838, 'B-MISC': -9.653 },
			z: 8.905,
			probabilities: { 'I-PER': 0.753, O: 0.247, 'B-LOC': 0, 'B-MISC': 0 },
		},
	],
	[
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'shape=Xxxxx', tag: 'I-PER', value: 1, weight: 0.327 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.258 },
					{ feature: 'word=53', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'lowercase=2', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'lowercase=russell', tag: 'I-PER', weight: 0.302, value: 0 },
					{ feature: 'word=48', tag: 'O', weight: 0.206, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.235 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'word=Esnaider', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'lowercase=this', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=Fritz', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'lowercase=ismail', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'lowercase=believe', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { 'I-PER': -0.87, O: -5.014 },
			z: 0.426,
			probabilities: { 'I-PER': 0.983, O: 0.016 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'shape=Xxxxxx', tag: 'I-PER', value: 1, weight: 0.327 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.258 },
					{ feature: 'lowercase=57', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'word=shared', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=4-45', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=continued', tag: 'O', weight: 0.188, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.235 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'lowercase=londono', tag: 'I-PER', weight: 0.302, value: 0 },
					{ feature: 'word=this', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=Angeli', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'lowercase=7-6', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=eijden', tag: 'I-PER', weight: 0.472, value: 0 },
				],
			},
			sums: { 'I-PER': -0.87, O: -5.014 },
			z: 0.426,
			probabilities: { 'I-PER': 0.983, O: 0.016 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'shape=Xxxxx', tag: 'I-PER', value: 1, weight: 0.327 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.258 },
					{ feature: 'lowercase=8', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'lowercase=301,972', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=Bronckhorst', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'word=4-53', tag: 'O', weight: 0.188, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.235 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'lowercase=jackson', tag: 'I-PER', weight: 0.302, value: 0 },
					{ feature: 'word=Schalkwyk', tag: 'I-PER', weight: 0.445, value: 0 },
					{ feature: 'shape=Xxxxxxxxxxx', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'lowercase=ortega', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'word=made', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { 'I-PER': -0.87, O: -5.014 },
			z: 0.426,
			probabilities: { 'I-PER': 0.983, O: 0.016 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.258 },
					{ feature: 'lowercase=7-2-24-1', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=next', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=spent', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=lago', tag: 'I-PER', weight: 0.311, value: 0 },
					{ feature: 'word=are', tag: 'O', weight: 0.192, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.235 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'word=Jackson', tag: 'I-PER', weight: 0.302, value: 0 },
					{ feature: 'word=Maso', tag: 'I-PER', weight: 0.311, value: 0 },
					{ feature: 'lowercase=6-65', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=2', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'word=applauded', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { 'I-PER': -1.197, O: -5.014 },
			z: 0.309,
			probabilities: { 'I-PER': 0.978, O: 0.022 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'shape=Xxxxxx', tag: 'I-PER', value: 1, weight: 0.327 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.258 },
					{ feature: 'lowercase=signed', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=7-2-11-0', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=upstaged', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=4-35', tag: 'O', weight: 0.188, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.235 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'lowercase=londono', tag: 'I-PER', weight: 0.302, value: 0 },
					{ feature: 'word=51', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'word=55', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'word=Jalil', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'word=belted', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { 'I-PER': -0.87, O: -5.014 },
			z: 0.426,
			probabilities: { 'I-PER': 0.983, O: 0.016 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-PER', value: 1, weight: 0.327 },
					{ feature: 'is_title_case', tag: 'I-PER', value: 1, weight: 0.258 },
					{ feature: 'word=because', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=Coers', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'lowercase=struck', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=7-2-11-0', tag: 'O', weight: 0.188, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -5.235 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'word=Noce', tag: 'I-PER', weight: 0.311, value: 0 },
					{ feature: 'lowercase=plunges', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=into', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=24', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'lowercase=here', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { 'I-PER': -0.87, O: -5.014 },
			z: 0.426,
			probabilities: { 'I-PER': 0.983, O: 0.016 },
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.13 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.125 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'word=Wath', tag: 'I-PER', weight: 0.311, value: 0 },
					{ feature: 'lowercase=2-1-4-0', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=4', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'word=Ongania', tag: 'O', weight: 4.367, value: 0 },
				],
				'I-PER': [
					{ feature: 'is_not_title_case', tag: 'I-PER', value: 1, weight: -4.344 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'lowercase=were', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'lowercase=52', tag: 'O', weight: 0.206, value: 0 },
					{ feature: 'word=Chateaubriand', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'word=6-4', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=expressed', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { O: 0.476, 'I-PER': -5.799 },
			z: 1.613,
			probabilities: { O: 0.998, 'I-PER': 0.002 },
		},
		{
			features: {
				'I-PER': [
					{ feature: 'is_not_title_case', tag: 'I-PER', value: 1, weight: -4.344 },
					{ feature: 'word=de', tag: 'I-PER', value: 1, weight: 3.429 },
					{ feature: 'lowercase=de', tag: 'I-PER', value: 1, weight: 3.429 },
					{ feature: 'is_not_uppercase', tag: 'I-PER', value: 1, weight: -0.77 },
					{ feature: 'is_not_digit', tag: 'I-PER', value: 1, weight: -0.685 },
					{ feature: 'shape=xx', tag: 'I-PER', value: 1, weight: 0.524 },
					{ feature: 'word=beat', tag: 'O', weight: 0.188, value: 0 },
					{ feature: 'word=completed', tag: 'O', weight: 0.188, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.125 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.112 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.109 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.099 },
					{ feature: 'word=Pas', tag: 'I-PER', weight: 0.472, value: 0 },
					{ feature: 'word=Jackson', tag: 'I-PER', weight: 0.302, value: 0 },
					{ feature: 'word=Seko', tag: 'I-PER', weight: 0.311, value: 0 },
					{ feature: 'shape=-', tag: 'O', weight: 0.188, value: 0 },
				],
			},
			sums: { 'I-PER': 1.583, O: 0.445 },
			z: 6.43,
			probabilities: { 'I-PER': 0.757, O: 0.243 },
		},
	],
	[
		{
			features: {
				'I-LOC': [
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'shape=Xxxxx', tag: 'I-LOC', value: 1, weight: 0.355 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'word=some', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=spring', tag: 'O', weight: 3.292, value: 0 },
					{ feature: 'word=ECOMOG', tag: 'B-ORG', weight: 3.472, value: 0 },
					{ feature: 'word=hydroelectric', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: -0.31 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.242 },
					{ feature: 'word=some', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.546, value: 0 },
					{ feature: 'word=ECOMOG', tag: 'B-ORG', weight: 3.472, value: 0 },
					{ feature: 'word=hydroelectric', tag: 'O', weight: 0.569, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -4.309 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.02 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.546, value: 0 },
					{ feature: 'word=ECOMOG', tag: 'B-ORG', weight: 3.472, value: 0 },
					{ feature: 'word=hydroelectric', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=F-14', tag: 'B-MISC', weight: 2.311, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.2 },
					{ feature: 'word=some', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.546, value: 0 },
					{ feature: 'word=plans', tag: 'O', weight: 0.488, value: 0 },
					{ feature: 'word=F-14', tag: 'B-MISC', weight: 2.311, value: 0 },
					{ feature: 'lowercase=zealand', tag: 'I-LOC', weight: 0.707, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -1.436 },
					{ feature: 'word=some', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.546, value: 0 },
					{ feature: 'word=ECOMOG', tag: 'B-ORG', weight: 3.472, value: 0 },
					{ feature: 'word=hydroelectric', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=F-14', tag: 'B-MISC', weight: 2.311, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.59 },
					{ feature: 'word=some', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.546, value: 0 },
					{ feature: 'word=ECOMOG', tag: 'B-ORG', weight: 3.472, value: 0 },
					{ feature: 'word=hydroelectric', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=F-14', tag: 'B-MISC', weight: 2.311, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.133,
				'B-MISC': -3.714,
				O: -4.685,
				'B-ORG': -7.007,
				'B-LOC': -7.862,
				'B-PER': -10.66,
			},
			z: 1.177,
			probabilities: {
				'I-LOC': 0.97,
				'B-MISC': 0.021,
				O: 0.008,
				'B-ORG': 0.001,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'shape=Xxxxxx', tag: 'I-LOC', value: 1, weight: 0.379 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'word=cents', tag: 'O', weight: 0.488, value: 0 },
					{ feature: 'lowercase=likely', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=working', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=england', tag: 'I-LOC', weight: 0.638, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -2.963 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.02 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'word=Ljupce', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'O', weight: -4.441, value: 0 },
					{ feature: 'lowercase=boy', tag: 'O', weight: 0.481, value: 0 },
					{ feature: 'lowercase=so', tag: 'O', weight: 0.496, value: 0 },
				],
				'B-MISC': [
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: -1.893 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.242 },
					{ feature: 'word=cents', tag: 'O', weight: 0.488, value: 0 },
					{ feature: 'word=Ljupce', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'O', weight: -4.441, value: 0 },
					{ feature: 'lowercase=boy', tag: 'O', weight: 0.481, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.2 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.812 },
					{ feature: 'word=cents', tag: 'O', weight: 0.488, value: 0 },
					{ feature: 'word=Ljupce', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'O', weight: -4.441, value: 0 },
					{ feature: 'lowercase=boy', tag: 'O', weight: 0.481, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -1.436 },
					{ feature: 'word=cents', tag: 'O', weight: 0.488, value: 0 },
					{ feature: 'word=Ljupce', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'O', weight: -4.441, value: 0 },
					{ feature: 'lowercase=boy', tag: 'O', weight: 0.481, value: 0 },
					{ feature: 'lowercase=so', tag: 'O', weight: 0.496, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.59 },
					{ feature: 'word=cents', tag: 'O', weight: 0.488, value: 0 },
					{ feature: 'word=Ljupce', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'O', weight: -4.441, value: 0 },
					{ feature: 'lowercase=boy', tag: 'O', weight: 0.481, value: 0 },
					{ feature: 'lowercase=so', tag: 'O', weight: 0.496, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.156,
				O: -3.339,
				'B-MISC': -5.298,
				'B-ORG': -6.195,
				'B-LOC': -7.862,
				'B-PER': -10.66,
			},
			z: 1.212,
			probabilities: {
				'I-LOC': 0.964,
				O: 0.029,
				'B-MISC': 0.004,
				'B-ORG': 0.002,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'shape=Xxxxx', tag: 'I-LOC', value: 1, weight: 0.355 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'shape=dd,ddd.dd', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=from', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word="\'S"', tag: 'O', weight: 1.874, value: 0 },
					{ feature: 'lowercase=target', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: -0.31 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.242 },
					{ feature: 'shape=dd,ddd.dd', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Bernabeu', tag: 'I-LOC', weight: 0.801, value: 0 },
					{ feature: 'word=Aviv', tag: 'I-LOC', weight: 0.621, value: 0 },
					{ feature: 'word=Trust', tag: 'I-LOC', weight: 0.589, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -4.309 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.02 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'word=Bernabeu', tag: 'I-LOC', weight: 0.801, value: 0 },
					{ feature: 'word=Aviv', tag: 'I-LOC', weight: 0.621, value: 0 },
					{ feature: 'word=Trust', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'word=club', tag: 'O', weight: 0.561, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.2 },
					{ feature: 'shape=dd,ddd.dd', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Bernabeu', tag: 'I-LOC', weight: 0.801, value: 0 },
					{ feature: 'word=Aviv', tag: 'I-LOC', weight: 0.621, value: 0 },
					{ feature: 'word=Trust', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'word=club', tag: 'O', weight: 0.561, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -1.436 },
					{ feature: 'shape=dd,ddd.dd', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Bernabeu', tag: 'I-LOC', weight: 0.801, value: 0 },
					{ feature: 'word=Aviv', tag: 'I-LOC', weight: 0.621, value: 0 },
					{ feature: 'word=Trust', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'word=club', tag: 'O', weight: 0.561, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.59 },
					{ feature: 'shape=dd,ddd.dd', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Bernabeu', tag: 'I-LOC', weight: 0.801, value: 0 },
					{ feature: 'word=Aviv', tag: 'I-LOC', weight: 0.621, value: 0 },
					{ feature: 'word=Trust', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'word=club', tag: 'O', weight: 0.561, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.133,
				'B-MISC': -3.714,
				O: -4.685,
				'B-ORG': -7.007,
				'B-LOC': -7.862,
				'B-PER': -10.66,
			},
			z: 1.177,
			probabilities: {
				'I-LOC': 0.97,
				'B-MISC': 0.021,
				O: 0.008,
				'B-ORG': 0.001,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'lowercase=missionaries', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=tv', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', weight: -2.47, value: 0 },
					{ feature: 'lowercase=airports', tag: 'O', weight: 0.468, value: 0 },
					{ feature: 'lowercase=brokerage', tag: 'O', weight: 0.569, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.02 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'word=Hopkins', tag: 'I-LOC', weight: 0.638, value: 0 },
					{ feature: 'lowercase=tv', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', weight: -2.47, value: 0 },
					{ feature: 'lowercase=airports', tag: 'O', weight: 0.468, value: 0 },
					{ feature: 'lowercase=brokerage', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.242 },
					{ feature: 'lowercase=missionaries', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Hopkins', tag: 'I-LOC', weight: 0.638, value: 0 },
					{ feature: 'lowercase=tv', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', weight: -2.47, value: 0 },
					{ feature: 'lowercase=airports', tag: 'O', weight: 0.468, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.2 },
					{ feature: 'lowercase=missionaries', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Hopkins', tag: 'I-LOC', weight: 0.638, value: 0 },
					{ feature: 'lowercase=football', tag: 'I-LOC', weight: 0.801, value: 0 },
					{ feature: 'word=agricultural', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=bought', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -1.436 },
					{ feature: 'lowercase=missionaries', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Hopkins', tag: 'I-LOC', weight: 0.638, value: 0 },
					{ feature: 'lowercase=tv', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', weight: -2.47, value: 0 },
					{ feature: 'lowercase=airports', tag: 'O', weight: 0.468, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.59 },
					{ feature: 'lowercase=missionaries', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Hopkins', tag: 'I-LOC', weight: 0.638, value: 0 },
					{ feature: 'lowercase=tv', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', weight: -2.47, value: 0 },
					{ feature: 'lowercase=airports', tag: 'O', weight: 0.468, value: 0 },
				],
			},
			sums: {
				'I-LOC': -0.222,
				O: -0.376,
				'B-MISC': -3.404,
				'B-ORG': -7.007,
				'B-LOC': -7.862,
				'B-PER': -10.66,
			},
			z: 1.522,
			probabilities: {
				'I-LOC': 0.526,
				O: 0.451,
				'B-MISC': 0.022,
				'B-ORG': 0.001,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'word=Senate', tag: 'B-ORG', value: 1, weight: 3.821 },
					{ feature: 'lowercase=senate', tag: 'B-ORG', value: 1, weight: 3.821 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.2 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.812 },
					{ feature: 'lowercase=resort', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Tipperary', tag: 'I-LOC', weight: 1.16, value: 0 },
				],
				'I-LOC': [
					{ feature: 'shape=Xxxxxx', tag: 'I-LOC', value: 1, weight: 0.379 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'lowercase=resort', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=TV', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'word=Democrat', tag: 'B-MISC', weight: 3.437, value: 0 },
					{ feature: 'lowercase=work', tag: 'O', weight: 0.569, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -2.963 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.02 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'word=Tipperary', tag: 'I-LOC', weight: 1.16, value: 0 },
					{ feature: 'word=TV', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'word=Democrat', tag: 'B-MISC', weight: 3.437, value: 0 },
					{ feature: 'lowercase=work', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-MISC': [
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: -1.893 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.242 },
					{ feature: 'lowercase=resort', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Tipperary', tag: 'I-LOC', weight: 1.16, value: 0 },
					{ feature: 'word=TV', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'word=ruled', tag: 'O', weight: 0.488, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -1.436 },
					{ feature: 'lowercase=resort', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Tipperary', tag: 'I-LOC', weight: 1.16, value: 0 },
					{ feature: 'word=TV', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'word=Democrat', tag: 'B-MISC', weight: 3.437, value: 0 },
					{ feature: 'lowercase=work', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.59 },
					{ feature: 'lowercase=resort', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=Tipperary', tag: 'I-LOC', weight: 1.16, value: 0 },
					{ feature: 'word=TV', tag: 'B-ORG', weight: 3.562, value: 0 },
					{ feature: 'word=Democrat', tag: 'B-MISC', weight: 3.437, value: 0 },
					{ feature: 'lowercase=work', tag: 'O', weight: 0.569, value: 0 },
				],
			},
			sums: {
				'B-ORG': 1.446,
				'I-LOC': 0.156,
				O: -3.339,
				'B-MISC': -5.298,
				'B-LOC': -7.862,
				'B-PER': -10.66,
			},
			z: 5.456,
			probabilities: {
				'B-ORG': 0.778,
				'I-LOC': 0.214,
				O: 0.007,
				'B-MISC': 0.001,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'shape=Xxxxxxxx', tag: 'I-LOC', value: 1, weight: 0.4 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'lowercase=6', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=high', tag: 'B-LOC', weight: 5.783, value: 0 },
					{ feature: 'lowercase=mission', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ELITE', tag: 'O', weight: 1.428, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxxxx', tag: 'O', value: 1, weight: -1.966 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.02 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'lowercase=pueblo', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'lowercase=high', tag: 'B-LOC', weight: 5.783, value: 0 },
					{ feature: 'lowercase=mission', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ELITE', tag: 'O', weight: 1.428, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-MISC', value: 1, weight: 0.333 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.242 },
					{ feature: 'lowercase=6', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=pueblo', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'lowercase=high', tag: 'B-LOC', weight: 5.783, value: 0 },
					{ feature: 'lowercase=mission', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -1.2 },
					{ feature: 'lowercase=6', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=pueblo', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'lowercase=high', tag: 'B-LOC', weight: 5.783, value: 0 },
					{ feature: 'lowercase=mission', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ELITE', tag: 'O', weight: 1.428, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -1.436 },
					{ feature: 'lowercase=6', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=pueblo', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'word=because', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=CLUB', tag: 'O', weight: 2.023, value: 0 },
					{ feature: 'word=(', tag: 'I-LOC', weight: 0.837, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-PER', value: 1, weight: 0.886 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.59 },
					{ feature: 'lowercase=6', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=pueblo', tag: 'I-LOC', weight: 0.633, value: 0 },
					{ feature: 'lowercase=high', tag: 'B-LOC', weight: 5.783, value: 0 },
					{ feature: 'lowercase=mission', tag: 'O', weight: 0.569, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.177,
				O: -2.342,
				'B-MISC': -3.071,
				'B-ORG': -7.007,
				'B-LOC': -7.862,
				'B-PER': -9.774,
			},
			z: 1.337,
			probabilities: {
				'I-LOC': 0.893,
				O: 0.072,
				'B-MISC': 0.035,
				'B-ORG': 0.001,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.397 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.338 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'lowercase=zealand', tag: 'I-LOC', weight: 0.707, value: 0 },
					{ feature: 'lowercase=202', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=vegas', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.308, value: 0 },
				],
				'I-LOC': [
					{ feature: 'is_not_title_case', tag: 'I-LOC', value: 1, weight: -1.662 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'shape=xxxxxxxxxxx', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=226-5', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=7.85', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.308, value: 0 },
					{ feature: 'shape="xxx\'x"', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -3.298 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'shape=xxxxxxxxxxx', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=zealand', tag: 'I-LOC', weight: 0.707, value: 0 },
					{ feature: 'lowercase=202', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=vegas', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'word=earlier', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -1.95 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'shape=xxxxxxxxxxx', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=zealand', tag: 'I-LOC', weight: 0.707, value: 0 },
					{ feature: 'lowercase=202', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=vegas', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.308, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -1.963 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'shape=xxxxxxxxxxx', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=zealand', tag: 'I-LOC', weight: 0.707, value: 0 },
					{ feature: 'lowercase=202', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=vegas', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.308, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'shape=xxxxxxxxxxx', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=zealand', tag: 'I-LOC', weight: 0.707, value: 0 },
					{ feature: 'lowercase=202', tag: 'O', weight: 0.596, value: 0 },
					{ feature: 'lowercase=vegas', tag: 'I-LOC', weight: 0.589, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.308, value: 0 },
					{ feature: 'shape="xxx\'x"', tag: 'O', weight: 0.569, value: 0 },
				],
			},
			sums: {
				O: 1.379,
				'I-LOC': -2.238,
				'B-MISC': -6.46,
				'B-ORG': -7.757,
				'B-LOC': -8.389,
				'B-PER': -10.07,
			},
			z: 4.08,
			probabilities: {
				O: 0.973,
				'I-LOC': 0.026,
				'B-MISC': 0,
				'B-ORG': 0,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'word=de', tag: 'I-LOC', value: 1, weight: 3.158 },
					{ feature: 'lowercase=de', tag: 'I-LOC', value: 1, weight: 2.203 },
					{ feature: 'is_not_title_case', tag: 'I-LOC', value: 1, weight: -1.662 },
					{ feature: 'shape=xx', tag: 'I-LOC', value: 1, weight: -1.08 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.361 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.214 },
					{ feature: 'word=asks', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=midfielder', tag: 'O', weight: 0.569, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.338 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.315 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.312 },
					{ feature: 'word=leader', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ANGELES', tag: 'I-LOC', weight: 1.425, value: 0 },
					{ feature: 'word=Territories', tag: 'I-LOC', weight: 1.127, value: 0 },
					{ feature: 'lowercase=mt', tag: 'B-LOC', weight: 3.078, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -3.298 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.712 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.45 },
					{ feature: 'word=asks', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=midfielder', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ANGELES', tag: 'I-LOC', weight: 1.425, value: 0 },
					{ feature: 'word=Territories', tag: 'I-LOC', weight: 1.127, value: 0 },
					{ feature: 'lowercase=mt', tag: 'B-LOC', weight: 3.078, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -4.007 },
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -1.95 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.801 },
					{ feature: 'word=asks', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=midfielder', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ANGELES', tag: 'I-LOC', weight: 1.425, value: 0 },
					{ feature: 'word=Territories', tag: 'I-LOC', weight: 1.127, value: 0 },
					{ feature: 'lowercase=mt', tag: 'B-LOC', weight: 3.078, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -4.542 },
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -1.963 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.884 },
					{ feature: 'word=asks', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=midfielder', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'word=ANGELES', tag: 'I-LOC', weight: 1.425, value: 0 },
					{ feature: 'word=Territories', tag: 'I-LOC', weight: 1.127, value: 0 },
					{ feature: 'word=avoided', tag: 'O', weight: 0.569, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -6.058 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -4.013 },
					{ feature: 'word=asks', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'lowercase=midfielder', tag: 'O', weight: 0.569, value: 0 },
					{ feature: 'is_not_title_case', tag: 'B-MISC', weight: -4.758, value: 0 },
					{ feature: 'word=ANGELES', tag: 'I-LOC', weight: 1.425, value: 0 },
					{ feature: 'word=Territories', tag: 'I-LOC', weight: 1.127, value: 0 },
					{ feature: 'lowercase=mt', tag: 'B-LOC', weight: 3.078, value: 0 },
				],
			},
			sums: {
				'I-LOC': 2.043,
				O: 1.294,
				'B-MISC': -6.46,
				'B-ORG': -7.757,
				'B-LOC': -8.389,
				'B-PER': -10.07,
			},
			z: 11.363,
			probabilities: {
				'I-LOC': 0.679,
				O: 0.321,
				'B-MISC': 0,
				'B-ORG': 0,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
	],
	[
		{
			features: {
				'I-LOC': [
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.476 },
					{ feature: 'shape=Xxxxx', tag: 'I-LOC', value: 1, weight: 0.445 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'lowercase=149,100-a', tag: 'O', weight: 1.745, value: 0 },
					{ feature: 'lowercase=1-0', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=release', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=Hang', tag: 'B-MISC', weight: 3.689, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.437 },
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -0.506 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'word=Angels', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=AND', tag: 'O', weight: 0.658, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.475, value: 0 },
					{ feature: 'word=Hang', tag: 'B-MISC', weight: 3.689, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.456 },
					{ feature: 'lowercase=149,100-a', tag: 'O', weight: 1.745, value: 0 },
					{ feature: 'word=Angels', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=AND', tag: 'O', weight: 0.658, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.475, value: 0 },
					{ feature: 'lowercase=gulf', tag: 'I-LOC', weight: 0.822, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.551 },
					{ feature: 'lowercase=149,100-a', tag: 'O', weight: 1.745, value: 0 },
					{ feature: 'word=Angels', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=AND', tag: 'O', weight: 0.658, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.475, value: 0 },
					{ feature: 'word=Hang', tag: 'B-MISC', weight: 3.689, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.862 },
					{ feature: 'lowercase=149,100-a', tag: 'O', weight: 1.745, value: 0 },
					{ feature: 'word=Angels', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=AND', tag: 'O', weight: 0.658, value: 0 },
					{ feature: 'shape=Xxxx', tag: 'I-LOC', weight: 0.475, value: 0 },
					{ feature: 'word=Hang', tag: 'B-MISC', weight: 3.689, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.257,
				O: -1.392,
				'B-MISC': -4.414,
				'B-LOC': -5.385,
				'B-ORG': -6.128,
			},
			z: 1.56,
			probabilities: {
				'I-LOC': 0.829,
				O: 0.159,
				'B-MISC': 0.008,
				'B-LOC': 0.003,
				'B-ORG': 0.001,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'shape=Xxxxxx', tag: 'I-LOC', value: 1, weight: 0.663 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.476 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=girl', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=off', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'word=reads', tag: 'O', weight: 0.499, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.437 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'lowercase=31', tag: 'I-LOC', weight: 2.106, value: 0 },
					{ feature: 'lowercase=does', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'lowercase=beach', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=or', tag: 'O', weight: 0.497, value: 0 },
					{ feature: 'word=seven', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'shape=Xxxxxx', tag: 'B-LOC', value: 1, weight: 1.54 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.551 },
					{ feature: 'lowercase=31', tag: 'I-LOC', weight: 2.106, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=girl', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=off', tag: 'O', weight: 0.467, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 2.043 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.862 },
					{ feature: 'lowercase=31', tag: 'I-LOC', weight: 2.106, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=girl', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=off', tag: 'O', weight: 0.467, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.456 },
					{ feature: 'lowercase=31', tag: 'I-LOC', weight: 2.106, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=girl', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=off', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'word=reads', tag: 'O', weight: 0.499, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.475,
				O: -0.885,
				'B-LOC': -3.845,
				'B-ORG': -4.085,
				'B-MISC': -4.414,
			},
			z: 2.071,
			probabilities: {
				'I-LOC': 0.776,
				O: 0.199,
				'B-LOC': 0.01,
				'B-ORG': 0.008,
				'B-MISC': 0.006,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.476 },
					{ feature: 'shape=Xxxxx', tag: 'I-LOC', value: 1, weight: 0.445 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'shape=XXXXXX', tag: 'O', weight: 0.646, value: 0 },
					{ feature: 'word=beach', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=plans', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=angeles', tag: 'I-LOC', weight: 0.935, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.437 },
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -0.506 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'word=Republic', tag: 'I-LOC', weight: 1.055, value: 0 },
					{ feature: 'lowercase=scored', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=elections', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=Valley', tag: 'I-LOC', weight: 1.074, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.456 },
					{ feature: 'word=Republic', tag: 'I-LOC', weight: 1.055, value: 0 },
					{ feature: 'shape=XXXXXX', tag: 'O', weight: 0.646, value: 0 },
					{ feature: 'word=beach', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=plans', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=angeles', tag: 'I-LOC', weight: 0.935, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.551 },
					{ feature: 'word=Republic', tag: 'I-LOC', weight: 1.055, value: 0 },
					{ feature: 'shape=XXXXXX', tag: 'O', weight: 0.646, value: 0 },
					{ feature: 'word=beach', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=plans', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=angeles', tag: 'I-LOC', weight: 0.935, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.862 },
					{ feature: 'word=Republic', tag: 'I-LOC', weight: 1.055, value: 0 },
					{ feature: 'shape=XXXXXX', tag: 'O', weight: 0.646, value: 0 },
					{ feature: 'word=beach', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=plans', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=angeles', tag: 'I-LOC', weight: 0.935, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.257,
				O: -1.392,
				'B-MISC': -4.414,
				'B-LOC': -5.385,
				'B-ORG': -6.128,
			},
			z: 1.56,
			probabilities: {
				'I-LOC': 0.829,
				O: 0.159,
				'B-MISC': 0.008,
				'B-LOC': 0.003,
				'B-ORG': 0.001,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.476 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'lowercase=walkover', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=Independent', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=state', tag: 'O', weight: 0.357, value: 0 },
					{ feature: 'lowercase=speeches', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=D.C.', tag: 'I-LOC', weight: 1.004, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.437 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'shape=Xxxxxxxxxxx', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'word=6-3', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=)', tag: 'I-LOC', weight: 0.202, value: 0 },
					{ feature: 'word=play', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'lowercase=some', tag: 'O', weight: 0.455, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.456 },
					{ feature: 'shape=Xxxxxxxxxxx', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=walkover', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=Independent', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=state', tag: 'O', weight: 0.357, value: 0 },
					{ feature: 'lowercase=speeches', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.551 },
					{ feature: 'shape=Xxxxxxxxxxx', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=walkover', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=Independent', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=state', tag: 'O', weight: 0.357, value: 0 },
					{ feature: 'lowercase=speeches', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.862 },
					{ feature: 'shape=Xxxxxxxxxxx', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=walkover', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=Independent', tag: 'I-LOC', weight: 1.042, value: 0 },
					{ feature: 'lowercase=state', tag: 'O', weight: 0.357, value: 0 },
					{ feature: 'lowercase=speeches', tag: 'O', weight: 0.499, value: 0 },
				],
			},
			sums: {
				'I-LOC': -0.188,
				O: -0.885,
				'B-MISC': -4.414,
				'B-LOC': -5.385,
				'B-ORG': -6.128,
			},
			z: 1.26,
			probabilities: {
				'I-LOC': 0.658,
				O: 0.328,
				'B-MISC': 0.01,
				'B-LOC': 0.004,
				'B-ORG': 0.002,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'shape=Xxxxxx', tag: 'I-LOC', value: 1, weight: 0.663 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.476 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'word=envoy', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=which', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=WA', tag: 'B-LOC', weight: 2.556, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.437 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'shape=dd', tag: 'I-LOC', weight: 1.353, value: 0 },
					{ feature: 'word=where', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'shape=xx', tag: 'O', weight: 0.355, value: 0 },
					{ feature: 'word=WA', tag: 'B-LOC', weight: 2.556, value: 0 },
					{ feature: 'lowercase=people', tag: 'I-LOC', weight: 1.074, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'shape=Xxxxxx', tag: 'B-LOC', value: 1, weight: 1.54 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.551 },
					{ feature: 'shape=dd', tag: 'I-LOC', weight: 1.353, value: 0 },
					{ feature: 'word=envoy', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=which', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.455, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 2.043 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.862 },
					{ feature: 'shape=dd', tag: 'I-LOC', weight: 1.353, value: 0 },
					{ feature: 'word=envoy', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=which', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.455, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.456 },
					{ feature: 'shape=dd', tag: 'I-LOC', weight: 1.353, value: 0 },
					{ feature: 'word=envoy', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=which', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=WA', tag: 'B-LOC', weight: 2.556, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.475,
				O: -0.885,
				'B-LOC': -3.845,
				'B-ORG': -4.085,
				'B-MISC': -4.414,
			},
			z: 2.071,
			probabilities: {
				'I-LOC': 0.776,
				O: 0.199,
				'B-LOC': 0.01,
				'B-ORG': 0.008,
				'B-MISC': 0.006,
			},
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'shape=Xxxxxxxx', tag: 'I-LOC', value: 1, weight: 0.649 },
					{ feature: 'is_title_case', tag: 'I-LOC', value: 1, weight: 0.476 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'word=near', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=Daewoo', tag: 'B-ORG', weight: 4.614, value: 0 },
					{ feature: 'word=found', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'word=MT', tag: 'B-LOC', weight: 2.556, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -1.437 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'word=Daewoo', tag: 'B-ORG', weight: 4.614, value: 0 },
					{ feature: 'shape=xxx', tag: 'I-LOC', weight: -0.441, value: 0 },
					{ feature: 'lowercase=won', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'word=MT', tag: 'B-LOC', weight: 2.556, value: 0 },
					{ feature: 'word=Hang', tag: 'B-MISC', weight: 3.689, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.456 },
					{ feature: 'word=near', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=Daewoo', tag: 'B-ORG', weight: 4.614, value: 0 },
					{ feature: 'shape=xxx', tag: 'I-LOC', weight: -0.441, value: 0 },
					{ feature: 'lowercase=won', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'word=MT', tag: 'B-LOC', weight: 2.556, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.551 },
					{ feature: 'word=near', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=Daewoo', tag: 'B-ORG', weight: 4.614, value: 0 },
					{ feature: 'shape=xxx', tag: 'I-LOC', weight: -0.441, value: 0 },
					{ feature: 'lowercase=won', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'word=venture', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.862 },
					{ feature: 'word=near', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'shape=xxx', tag: 'I-LOC', weight: -0.441, value: 0 },
					{ feature: 'lowercase=won', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'word=MT', tag: 'B-LOC', weight: 2.556, value: 0 },
					{ feature: 'word=Hang', tag: 'B-MISC', weight: 3.689, value: 0 },
				],
			},
			sums: {
				'I-LOC': 0.461,
				O: -0.885,
				'B-MISC': -4.414,
				'B-LOC': -5.385,
				'B-ORG': -6.128,
			},
			z: 2.017,
			probabilities: {
				'I-LOC': 0.786,
				O: 0.205,
				'B-MISC': 0.006,
				'B-LOC': 0.002,
				'B-ORG': 0.001,
			},
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.346 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.303 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'word=Station', tag: 'I-LOC', weight: 0.935, value: 0 },
					{ feature: 'shape=XXXXX', tag: 'B-MISC', weight: 2.859, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=but', tag: 'O', weight: 0.467, value: 0 },
				],
				'I-LOC': [
					{ feature: 'is_not_title_case', tag: 'I-LOC', value: 1, weight: -2.073 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'lowercase=some', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'shape=XXXXX', tag: 'B-MISC', weight: 2.859, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=but', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'lowercase=began', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -1.935 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'word=Station', tag: 'I-LOC', weight: 0.935, value: 0 },
					{ feature: 'lowercase=some', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'shape=XXXXX', tag: 'B-MISC', weight: 2.859, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=but', tag: 'O', weight: 0.467, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -2.863 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'word=Station', tag: 'I-LOC', weight: 0.935, value: 0 },
					{ feature: 'lowercase=some', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=scored', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=in', tag: 'O', weight: 0.514, value: 0 },
					{ feature: 'lowercase=1996-08-22', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'word=Station', tag: 'I-LOC', weight: 0.935, value: 0 },
					{ feature: 'lowercase=some', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'shape=XXXXX', tag: 'B-MISC', weight: 2.859, value: 0 },
					{ feature: 'lowercase=stock', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=but', tag: 'O', weight: 0.467, value: 0 },
					{ feature: 'lowercase=began', tag: 'O', weight: 0.499, value: 0 },
				],
			},
			sums: {
				O: 1.2,
				'I-LOC': -2.737,
				'B-LOC': -6.769,
				'B-MISC': -6.82,
				'B-ORG': -6.991,
			},
			z: 3.388,
			probabilities: { O: 0.98, 'I-LOC': 0.019, 'B-LOC': 0, 'B-MISC': 0, 'B-ORG': 0 },
		},
		{
			features: {
				'I-LOC': [
					{ feature: 'word=de', tag: 'I-LOC', value: 1, weight: 2.458 },
					{ feature: 'lowercase=de', tag: 'I-LOC', value: 1, weight: 2.458 },
					{ feature: 'is_not_title_case', tag: 'I-LOC', value: 1, weight: -2.073 },
					{ feature: 'is_not_uppercase', tag: 'I-LOC', value: 1, weight: -0.343 },
					{ feature: 'is_not_digit', tag: 'I-LOC', value: 1, weight: -0.321 },
					{ feature: 'shape=xx', tag: 'I-LOC', value: 1, weight: 0.01 },
					{ feature: 'word=Press', tag: 'O', weight: 2.19, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.167, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.303 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.277 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.275 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.246 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.167, value: 0 },
					{ feature: 'word=School', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=Israel', tag: 'B-LOC', weight: 4.342, value: 0 },
					{ feature: 'word=jewelry', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -3.26 },
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -1.935 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.574 },
					{ feature: 'word=Press', tag: 'O', weight: 2.19, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.167, value: 0 },
					{ feature: 'word=School', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'lowercase="', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=reported', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -2.863 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.279 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.678 },
					{ feature: 'word=Press', tag: 'O', weight: 2.19, value: 0 },
					{ feature: 'lowercase=some', tag: 'O', weight: 0.455, value: 0 },
					{ feature: 'word=School', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=Israel', tag: 'B-LOC', weight: 4.342, value: 0 },
					{ feature: 'word=jewelry', tag: 'O', weight: 0.499, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -3.886 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -3.105 },
					{ feature: 'word=Press', tag: 'O', weight: 2.19, value: 0 },
					{ feature: 'lowercase=grand', tag: 'B-MISC', weight: 3.167, value: 0 },
					{ feature: 'word=School', tag: 'I-LOC', weight: 1.074, value: 0 },
					{ feature: 'word=Israel', tag: 'B-LOC', weight: 4.342, value: 0 },
					{ feature: 'word=jewelry', tag: 'O', weight: 0.499, value: 0 },
					{ feature: 'lowercase=villefranche', tag: 'I-LOC', weight: 1.042, value: 0 },
				],
			},
			sums: {
				'I-LOC': 2.19,
				O: 1.101,
				'B-LOC': -6.769,
				'B-MISC': -6.82,
				'B-ORG': -6.991,
			},
			z: 11.946,
			probabilities: { 'I-LOC': 0.748, O: 0.252, 'B-LOC': 0, 'B-MISC': 0, 'B-ORG': 0 },
		},
	],
	[
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.4 },
					{ feature: 'shape=Xxxxx', tag: 'I-MISC', value: 1, weight: 0.357 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'word=GAN', tag: 'B-ORG', weight: 3.664, value: 0 },
					{ feature: 'word=surged', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'word=Gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=fundamentalists', tag: 'O', weight: 0.691, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.69 },
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -0.527 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'word=GAN', tag: 'B-ORG', weight: 3.664, value: 0 },
					{ feature: 'lowercase=bill', tag: 'I-MISC', weight: 1.005, value: 0 },
					{ feature: 'word=Gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=fundamentalists', tag: 'O', weight: 0.691, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.228 },
					{ feature: 'shape=Xxxxx', tag: 'B-PER', value: 1, weight: 0.087 },
					{ feature: 'word=GAN', tag: 'B-ORG', weight: 3.664, value: 0 },
					{ feature: 'word=surged', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=bill', tag: 'I-MISC', weight: 1.005, value: 0 },
					{ feature: 'word=Catholic', tag: 'I-MISC', weight: 1.135, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: 0.567 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.326 },
					{ feature: 'word=GAN', tag: 'B-ORG', weight: 3.664, value: 0 },
					{ feature: 'word=surged', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=bill', tag: 'I-MISC', weight: 1.005, value: 0 },
					{ feature: 'word=Gavin', tag: 'B-PER', weight: 2.947, value: 0 },
				],
				'B-ORG': [
					{ feature: 'shape=Xxxxx', tag: 'B-ORG', value: 1, weight: -1.501 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.206 },
					{ feature: 'word=surged', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=bill', tag: 'I-MISC', weight: 1.005, value: 0 },
					{ feature: 'word=Gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=fundamentalists', tag: 'O', weight: 0.691, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.865 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 0.4 },
					{ feature: 'word=GAN', tag: 'B-ORG', weight: 3.664, value: 0 },
					{ feature: 'word=surged', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=bill', tag: 'I-MISC', weight: 1.005, value: 0 },
					{ feature: 'word=Gavin', tag: 'B-PER', weight: 2.947, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.45,
				O: -0.535,
				'B-PER': -1.741,
				'B-MISC': -2.432,
				'B-ORG': -3.884,
				'B-LOC': -3.962,
			},
			z: 2.457,
			probabilities: {
				'I-MISC': 0.638,
				O: 0.238,
				'B-PER': 0.071,
				'B-MISC': 0.036,
				'B-ORG': 0.008,
				'B-LOC': 0.008,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'shape=Xxxxxx', tag: 'I-MISC', value: 1, weight: 0.417 },
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.4 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'lowercase=material', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=interior', tag: 'B-ORG', weight: 6.809, value: 0 },
					{ feature: 'word=one-day', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Ramallah', tag: 'B-LOC', weight: 4.353, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -1.508 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.69 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'word=interior', tag: 'B-ORG', weight: 6.809, value: 0 },
					{ feature: 'word=one-day', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Lankan', tag: 'I-MISC', weight: 1.06, value: 0 },
					{ feature: 'word=Ramallah', tag: 'B-LOC', weight: 4.353, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.228 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 0.02 },
					{ feature: 'lowercase=material', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=interior', tag: 'B-ORG', weight: 6.809, value: 0 },
					{ feature: 'word=one-day', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Lankan', tag: 'I-MISC', weight: 1.06, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: -0.257 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.206 },
					{ feature: 'lowercase=material', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=president', tag: 'O', weight: 0.658, value: 0 },
					{ feature: 'word=Lankan', tag: 'I-MISC', weight: 1.06, value: 0 },
					{ feature: 'word=Ramallah', tag: 'B-LOC', weight: 4.353, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.326 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: -0.294 },
					{ feature: 'lowercase=material', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=interior', tag: 'B-ORG', weight: 6.809, value: 0 },
					{ feature: 'word=one-day', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Lankan', tag: 'I-MISC', weight: 1.06, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.865 },
					{ feature: 'shape=Xxxxxx', tag: 'B-LOC', value: 1, weight: -0.265 },
					{ feature: 'lowercase=material', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=interior', tag: 'B-ORG', weight: 6.809, value: 0 },
					{ feature: 'word=one-day', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Lankan', tag: 'I-MISC', weight: 1.06, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.51,
				O: -1.516,
				'B-PER': -1.808,
				'B-ORG': -2.64,
				'B-MISC': -3.293,
				'B-LOC': -4.626,
			},
			z: 2.167,
			probabilities: {
				'I-MISC': 0.768,
				O: 0.101,
				'B-PER': 0.076,
				'B-ORG': 0.033,
				'B-MISC': 0.017,
				'B-LOC': 0.005,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.4 },
					{ feature: 'shape=Xxxxx', tag: 'I-MISC', value: 1, weight: 0.357 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'word=SPRINT', tag: 'O', weight: 1.396, value: 0 },
					{ feature: 'lowercase=kimberly', tag: 'B-PER', weight: 2.786, value: 0 },
					{ feature: 'lowercase=re', tag: 'B-ORG', weight: 2.669, value: 0 },
					{ feature: 'lowercase=creation', tag: 'I-MISC', weight: 1.135, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.69 },
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -0.527 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'word=Americans', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'lowercase=kimberly', tag: 'B-PER', weight: 2.786, value: 0 },
					{ feature: 'lowercase=re', tag: 'B-ORG', weight: 2.669, value: 0 },
					{ feature: 'lowercase=creation', tag: 'I-MISC', weight: 1.135, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.228 },
					{ feature: 'shape=Xxxxx', tag: 'B-PER', value: 1, weight: 0.087 },
					{ feature: 'word=SPRINT', tag: 'O', weight: 1.396, value: 0 },
					{ feature: 'word=Americans', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'lowercase=re', tag: 'B-ORG', weight: 2.669, value: 0 },
					{ feature: 'lowercase=creation', tag: 'I-MISC', weight: 1.135, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: 0.567 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.326 },
					{ feature: 'word=SPRINT', tag: 'O', weight: 1.396, value: 0 },
					{ feature: 'word=Americans', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'lowercase=kimberly', tag: 'B-PER', weight: 2.786, value: 0 },
					{ feature: 'lowercase=re', tag: 'B-ORG', weight: 2.669, value: 0 },
				],
				'B-ORG': [
					{ feature: 'shape=Xxxxx', tag: 'B-ORG', value: 1, weight: -1.501 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.206 },
					{ feature: 'word=SPRINT', tag: 'O', weight: 1.396, value: 0 },
					{ feature: 'word=Americans', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'lowercase=kimberly', tag: 'B-PER', weight: 2.786, value: 0 },
					{ feature: 'lowercase=lm600', tag: 'I-MISC', weight: 1.528, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.865 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 0.4 },
					{ feature: 'word=SPRINT', tag: 'O', weight: 1.396, value: 0 },
					{ feature: 'word=Americans', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'lowercase=kimberly', tag: 'B-PER', weight: 2.786, value: 0 },
					{ feature: 'lowercase=re', tag: 'B-ORG', weight: 2.669, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.45,
				O: -0.535,
				'B-PER': -1.741,
				'B-MISC': -2.432,
				'B-ORG': -3.884,
				'B-LOC': -3.962,
			},
			z: 2.457,
			probabilities: {
				'I-MISC': 0.638,
				O: 0.238,
				'B-PER': 0.071,
				'B-MISC': 0.036,
				'B-ORG': 0.008,
				'B-LOC': 0.008,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.4 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'word=1.26', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=accuse', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=barbara', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', weight: -0.424, value: 0 },
					{ feature: 'lowercase=tank', tag: 'O', weight: 0.69, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.69 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'word=STRIKER', tag: 'O', weight: 1.218, value: 0 },
					{ feature: 'lowercase=barbara', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', weight: -0.424, value: 0 },
					{ feature: 'lowercase=ticket-cnn', tag: 'I-MISC', weight: 1.942, value: 0 },
					{ feature: 'shape=Xxxxxxxxx', tag: 'I-MISC', weight: -0.123, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.228 },
					{ feature: 'word=1.26', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=accuse', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', weight: -0.424, value: 0 },
					{ feature: 'lowercase=ticket-cnn', tag: 'I-MISC', weight: 1.942, value: 0 },
					{ feature: 'shape=Xxxxxxxxx', tag: 'I-MISC', weight: -0.123, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.206 },
					{ feature: 'word=1.26', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=accuse', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=barbara', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', weight: -0.424, value: 0 },
					{ feature: 'lowercase=ticket-cnn', tag: 'I-MISC', weight: 1.942, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.326 },
					{ feature: 'word=1.26', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=accuse', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=barbara', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'lowercase=ticket-cnn', tag: 'I-MISC', weight: 1.942, value: 0 },
					{ feature: 'shape=Xxxxxxxxx', tag: 'I-MISC', weight: -0.123, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.865 },
					{ feature: 'word=1.26', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=accuse', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=barbara', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', weight: -0.424, value: 0 },
					{ feature: 'lowercase=ticket-cnn', tag: 'I-MISC', weight: 1.942, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.093,
				O: -0.008,
				'B-PER': -1.828,
				'B-ORG': -2.383,
				'B-MISC': -2.999,
				'B-LOC': -4.361,
			},
			z: 2.405,
			probabilities: {
				'I-MISC': 0.456,
				O: 0.412,
				'B-PER': 0.067,
				'B-ORG': 0.038,
				'B-MISC': 0.021,
				'B-LOC': 0.005,
			},
		},
		{
			features: {
				'B-ORG': [
					{ feature: 'word=Senate', tag: 'B-ORG', value: 1, weight: 2.402 },
					{ feature: 'lowercase=senate', tag: 'B-ORG', value: 1, weight: 2.402 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: -0.257 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.206 },
					{ feature: 'word=part', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=--', tag: 'O', weight: 0.691, value: 0 },
				],
				'I-MISC': [
					{ feature: 'shape=Xxxxxx', tag: 'I-MISC', value: 1, weight: 0.417 },
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.4 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'word=part', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=--', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Kris', tag: 'B-PER', weight: 3.02, value: 0 },
					{ feature: 'word=kills', tag: 'O', weight: 0.69, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -1.508 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.69 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'lowercase=intolerance', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Kris', tag: 'B-PER', weight: 3.02, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: 1.19, value: 0 },
					{ feature: 'lowercase=v', tag: 'O', weight: 2.631, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.228 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 0.02 },
					{ feature: 'word=part', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=--', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: 1.19, value: 0 },
					{ feature: 'lowercase=v', tag: 'O', weight: 2.631, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.326 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: -0.294 },
					{ feature: 'word=part', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=--', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Kris', tag: 'B-PER', weight: 3.02, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: 1.19, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.865 },
					{ feature: 'shape=Xxxxxx', tag: 'B-LOC', value: 1, weight: -0.265 },
					{ feature: 'word=part', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=--', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Kris', tag: 'B-PER', weight: 3.02, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: 1.19, value: 0 },
				],
			},
			sums: {
				'B-ORG': 2.164,
				'I-MISC': 0.51,
				O: -1.516,
				'B-PER': -1.808,
				'B-MISC': -3.293,
				'B-LOC': -4.626,
			},
			z: 10.802,
			probabilities: {
				'B-ORG': 0.806,
				'I-MISC': 0.154,
				O: 0.02,
				'B-PER': 0.015,
				'B-MISC': 0.003,
				'B-LOC': 0.001,
			},
		},
		{
			features: {
				'B-ORG': [
					{ feature: 'lowercase=interior', tag: 'B-ORG', value: 1, weight: 2.058 },
					{ feature: 'word=Interior', tag: 'B-ORG', value: 1, weight: 1.384 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-ORG', value: 1, weight: 0.692 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.206 },
					{ feature: 'lowercase=prize', tag: 'I-MISC', weight: 1.267, value: 0 },
					{ feature: 'lowercase=islamic', tag: 'B-MISC', weight: 3.414, value: 0 },
				],
				O: [
					{ feature: 'word=Interior', tag: 'O', value: 1, weight: 2.492 },
					{ feature: 'shape=Xxxxxxxx', tag: 'O', value: 1, weight: -1.79 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.69 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'lowercase=interior', tag: 'O', value: 1, weight: 0.018 },
					{ feature: 'lowercase=prize', tag: 'I-MISC', weight: 1.267, value: 0 },
					{ feature: 'lowercase=islamic', tag: 'B-MISC', weight: 3.414, value: 0 },
				],
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.4 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', value: 1, weight: 0.322 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'lowercase=islamic', tag: 'B-MISC', weight: 3.414, value: 0 },
					{ feature: 'word=servicemen', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=gippsland', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'word=Mohamed', tag: 'B-PER', weight: 3.191, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: -0.228 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-PER', value: 1, weight: 0.17 },
					{ feature: 'lowercase=prize', tag: 'I-MISC', weight: 1.267, value: 0 },
					{ feature: 'lowercase=islamic', tag: 'B-MISC', weight: 3.414, value: 0 },
					{ feature: 'word=servicemen', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=gippsland', tag: 'I-MISC', weight: 1.701, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: -0.326 },
					{ feature: 'lowercase=prize', tag: 'I-MISC', weight: 1.267, value: 0 },
					{ feature: 'word=servicemen', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=gippsland', tag: 'I-MISC', weight: 1.701, value: 0 },
					{ feature: 'word=Mohamed', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'lowercase=policeman', tag: 'O', weight: 0.691, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: -0.865 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-LOC', value: 1, weight: 0.468 },
					{ feature: 'lowercase=prize', tag: 'I-MISC', weight: 1.267, value: 0 },
					{ feature: 'lowercase=islamic', tag: 'B-MISC', weight: 3.414, value: 0 },
					{ feature: 'word=servicemen', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=gippsland', tag: 'I-MISC', weight: 1.701, value: 0 },
				],
			},
			sums: {
				'B-ORG': 1.751,
				O: 0.712,
				'I-MISC': 0.415,
				'B-PER': -1.658,
				'B-MISC': -2.999,
				'B-LOC': -3.893,
			},
			z: 9.574,
			probabilities: {
				'B-ORG': 0.602,
				O: 0.213,
				'I-MISC': 0.158,
				'B-PER': 0.02,
				'B-MISC': 0.005,
				'B-LOC': 0.002,
			},
		},
		{
			features: {
				O: [
					{ feature: 'word=convention', tag: 'O', value: 1, weight: 0.533 },
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.483 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.387 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'lowercase=convention', tag: 'O', value: 1, weight: 0.267 },
					{ feature: 'word=Islamist', tag: 'I-MISC', weight: 1.135, value: 0 },
					{ feature: 'word=Formula', tag: 'B-MISC', weight: 3.899, value: 0 },
				],
				'I-MISC': [
					{ feature: 'is_not_title_case', tag: 'I-MISC', value: 1, weight: -0.968 },
					{ feature: 'lowercase=convention', tag: 'I-MISC', value: 1, weight: 0.32 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'word=followers', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Formula', tag: 'B-MISC', weight: 3.899, value: 0 },
					{ feature: 'lowercase=jail', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'word=Johnson', tag: 'B-PER', weight: 3.191, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -2.543 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'word=followers', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Islamist', tag: 'I-MISC', weight: 1.135, value: 0 },
					{ feature: 'word=cooperation', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Johnson', tag: 'B-PER', weight: 3.191, value: 0 },
					{ feature: 'word=NT', tag: 'I-MISC', weight: 1.607, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -3.291 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'word=followers', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Islamist', tag: 'I-MISC', weight: 1.135, value: 0 },
					{ feature: 'word=Formula', tag: 'B-MISC', weight: 3.899, value: 0 },
					{ feature: 'lowercase=jail', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'word=Johnson', tag: 'B-PER', weight: 3.191, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -3.089 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'word=followers', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Islamist', tag: 'I-MISC', weight: 1.135, value: 0 },
					{ feature: 'word=Formula', tag: 'B-MISC', weight: 3.899, value: 0 },
					{ feature: 'lowercase=jail', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'word=Johnson', tag: 'B-PER', weight: 3.191, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_title_case', tag: 'B-PER', value: 1, weight: -5.328 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'word=followers', tag: 'O', weight: 0.691, value: 0 },
					{ feature: 'word=Islamist', tag: 'I-MISC', weight: 1.135, value: 0 },
					{ feature: 'word=Formula', tag: 'B-MISC', weight: 3.899, value: 0 },
					{ feature: 'lowercase=jail', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'word=communists', tag: 'O', weight: 0.69, value: 0 },
				],
			},
			sums: {
				O: 2.352,
				'I-MISC': -0.956,
				'B-MISC': -5.217,
				'B-ORG': -5.469,
				'B-LOC': -6.585,
				'B-PER': -6.927,
			},
			z: 10.903,
			probabilities: {
				O: 0.964,
				'I-MISC': 0.035,
				'B-MISC': 0,
				'B-ORG': 0,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'word=de', tag: 'I-MISC', value: 1, weight: 1.789 },
					{ feature: 'lowercase=de', tag: 'I-MISC', value: 1, weight: 1.789 },
					{ feature: 'is_not_title_case', tag: 'I-MISC', value: 1, weight: -0.968 },
					{ feature: 'shape=xx', tag: 'I-MISC', value: 1, weight: 0.262 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.218 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.09 },
					{ feature: 'word=parrots', tag: 'O', weight: 0.506, value: 0 },
					{ feature: 'lowercase=gavin', tag: 'B-PER', weight: 2.947, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.387 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.353 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.329 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.224 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.288, value: 0 },
					{ feature: 'lowercase=gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=emphasised', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=area', tag: 'I-MISC', weight: 1.516, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -2.543 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.503 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -1.171 },
					{ feature: 'word=parrots', tag: 'O', weight: 0.506, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.288, value: 0 },
					{ feature: 'lowercase=gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=emphasised', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=area', tag: 'I-MISC', weight: 1.516, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -3.291 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.143 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.035 },
					{ feature: 'word=parrots', tag: 'O', weight: 0.506, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.288, value: 0 },
					{ feature: 'lowercase=gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=emphasised', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=area', tag: 'I-MISC', weight: 1.516, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -3.089 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -1.827 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -1.669 },
					{ feature: 'word=parrots', tag: 'O', weight: 0.506, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.288, value: 0 },
					{ feature: 'lowercase=gavin', tag: 'B-PER', weight: 2.947, value: 0 },
					{ feature: 'word=emphasised', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=area', tag: 'I-MISC', weight: 1.516, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_title_case', tag: 'B-PER', value: 1, weight: -5.328 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.859 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.741 },
					{ feature: 'word=parrots', tag: 'O', weight: 0.506, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.288, value: 0 },
					{ feature: 'lowercase=company', tag: 'O', weight: 0.615, value: 0 },
					{ feature: 'word=spot', tag: 'O', weight: 0.69, value: 0 },
					{ feature: 'lowercase=rugby', tag: 'O', weight: 0.732, value: 0 },
				],
			},
			sums: {
				'I-MISC': 2.563,
				O: 1.293,
				'B-MISC': -5.217,
				'B-ORG': -5.469,
				'B-LOC': -6.585,
				'B-PER': -6.927,
			},
			z: 16.63,
			probabilities: {
				'I-MISC': 0.78,
				O: 0.219,
				'B-MISC': 0,
				'B-ORG': 0,
				'B-LOC': 0,
				'B-PER': 0,
			},
		},
	],
	[
		{
			features: {
				'I-MISC': [
					{ feature: 'shape=Xxxxx', tag: 'I-MISC', value: 1, weight: 0.413 },
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.375 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'word=sides', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=leaders', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'word=match', tag: 'O', weight: 0.77, value: 0 },
					{ feature: 'lowercase=girl', tag: 'O', weight: 0.778, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -2.653 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'lowercase=:', tag: 'I-MISC', weight: 0.518, value: 0 },
					{ feature: 'word=Suite', tag: 'I-MISC', weight: 0.8, value: 0 },
					{ feature: 'lowercase=couple', tag: 'O', weight: 0.606, value: 0 },
					{ feature: 'word=THIRD', tag: 'O', weight: 1.142, value: 0 },
					{ feature: 'word=no', tag: 'I-MISC', weight: 2.837, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.68 },
					{ feature: 'shape=Xxxxx', tag: 'B-ORG', value: 1, weight: 0.634 },
					{ feature: 'lowercase=:', tag: 'I-MISC', weight: 0.518, value: 0 },
					{ feature: 'word=sides', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=leaders', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'word=match', tag: 'O', weight: 0.77, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: 1.362 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.569 },
					{ feature: 'lowercase=:', tag: 'I-MISC', weight: 0.518, value: 0 },
					{ feature: 'word=sides', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=leaders', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'word=match', tag: 'O', weight: 0.77, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 1.825 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.598 },
					{ feature: 'lowercase=:', tag: 'I-MISC', weight: 0.518, value: 0 },
					{ feature: 'word=sides', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=leaders', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'word=match', tag: 'O', weight: 0.77, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.55 },
					{ feature: 'lowercase=:', tag: 'I-MISC', weight: 0.518, value: 0 },
					{ feature: 'word=sides', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=leaders', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'word=match', tag: 'O', weight: 0.77, value: 0 },
					{ feature: 'lowercase=girl', tag: 'O', weight: 0.778, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.694,
				O: -1.988,
				'B-ORG': -3.192,
				'B-MISC': -3.515,
				'B-LOC': -3.814,
				'B-PER': -5.224,
			},
			z: 2.237,
			probabilities: {
				'I-MISC': 0.895,
				O: 0.061,
				'B-ORG': 0.018,
				'B-MISC': 0.013,
				'B-LOC': 0.01,
				'B-PER': 0.002,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.375 },
					{ feature: 'shape=Xxxxxx', tag: 'I-MISC', value: 1, weight: 0.232 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'word=naval', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=oil', tag: 'O', weight: 0.872, value: 0 },
					{ feature: 'word=double', tag: 'O', weight: 0.606, value: 0 },
					{ feature: 'lowercase=newspapers', tag: 'O', weight: 1.341, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -2.653 },
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -1.442 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'lowercase=ban', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'lowercase=series', tag: 'I-MISC', weight: 0.586, value: 0 },
					{ feature: 'word=junior', tag: 'O', weight: 0.606, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: 1.342 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.569 },
					{ feature: 'word=naval', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=ban', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'lowercase=series', tag: 'I-MISC', weight: 0.586, value: 0 },
					{ feature: 'word=junior', tag: 'O', weight: 0.606, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 1.546 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.55 },
					{ feature: 'word=naval', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=ban', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'lowercase=series', tag: 'I-MISC', weight: 0.586, value: 0 },
					{ feature: 'word=junior', tag: 'O', weight: 0.606, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.68 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.086 },
					{ feature: 'word=naval', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=ban', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'lowercase=series', tag: 'I-MISC', weight: 0.586, value: 0 },
					{ feature: 'word=junior', tag: 'O', weight: 0.606, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.598 },
					{ feature: 'word=naval', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'lowercase=ban', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'lowercase=series', tag: 'I-MISC', weight: 0.586, value: 0 },
					{ feature: 'word=junior', tag: 'O', weight: 0.606, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.513,
				O: -3.429,
				'B-MISC': -3.536,
				'B-PER': -3.678,
				'B-ORG': -3.739,
				'B-LOC': -5.639,
			},
			z: 1.784,
			probabilities: {
				'I-MISC': 0.936,
				O: 0.018,
				'B-MISC': 0.016,
				'B-PER': 0.014,
				'B-ORG': 0.013,
				'B-LOC': 0.002,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'shape=Xxxxx', tag: 'I-MISC', value: 1, weight: 0.413 },
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.375 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'lowercase=championship', tag: 'O', weight: -2.134, value: 0 },
					{ feature: 'lowercase=world', tag: 'B-MISC', weight: 4.159, value: 0 },
					{ feature: 'word=Two', tag: 'I-MISC', weight: 0.776, value: 0 },
					{ feature: 'lowercase=paramount', tag: 'B-ORG', weight: 3.347, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -2.653 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', weight: 0.536, value: 0 },
					{ feature: 'lowercase=world', tag: 'B-MISC', weight: 4.159, value: 0 },
					{ feature: 'word=Two', tag: 'I-MISC', weight: 0.776, value: 0 },
					{ feature: 'lowercase=paramount', tag: 'B-ORG', weight: 3.347, value: 0 },
					{ feature: 'lowercase=captain', tag: 'O', weight: 0.621, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.68 },
					{ feature: 'shape=Xxxxx', tag: 'B-ORG', value: 1, weight: 0.634 },
					{ feature: 'lowercase=championship', tag: 'O', weight: -2.134, value: 0 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', weight: 0.536, value: 0 },
					{ feature: 'lowercase=world', tag: 'B-MISC', weight: 4.159, value: 0 },
					{ feature: 'word=Two', tag: 'I-MISC', weight: 0.776, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: 1.362 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.569 },
					{ feature: 'lowercase=championship', tag: 'O', weight: -2.134, value: 0 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', weight: 0.536, value: 0 },
					{ feature: 'lowercase=weekend', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'lowercase=paramount', tag: 'B-ORG', weight: 3.347, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 1.825 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.598 },
					{ feature: 'lowercase=championship', tag: 'O', weight: -2.134, value: 0 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', weight: 0.536, value: 0 },
					{ feature: 'lowercase=world', tag: 'B-MISC', weight: 4.159, value: 0 },
					{ feature: 'word=Two', tag: 'I-MISC', weight: 0.776, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.55 },
					{ feature: 'lowercase=championship', tag: 'O', weight: -2.134, value: 0 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', weight: 0.536, value: 0 },
					{ feature: 'lowercase=world', tag: 'B-MISC', weight: 4.159, value: 0 },
					{ feature: 'word=Two', tag: 'I-MISC', weight: 0.776, value: 0 },
					{ feature: 'lowercase=paramount', tag: 'B-ORG', weight: 3.347, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.694,
				O: -1.988,
				'B-ORG': -3.192,
				'B-MISC': -3.515,
				'B-LOC': -3.814,
				'B-PER': -5.224,
			},
			z: 2.237,
			probabilities: {
				'I-MISC': 0.895,
				O: 0.061,
				'B-ORG': 0.018,
				'B-MISC': 0.013,
				'B-LOC': 0.01,
				'B-PER': 0.002,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.375 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'word=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=Disarmament', tag: 'I-MISC', weight: 0.747, value: 0 },
					{ feature: 'word=Peace', tag: 'I-MISC', weight: 0.8, value: 0 },
					{ feature: 'shape=Xxxxxxx', tag: 'B-LOC', weight: 2.827, value: 0 },
					{ feature: 'lowercase=partner', tag: 'O', weight: 0.621, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -2.653 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: -0.338, value: 0 },
					{ feature: 'lowercase=fast', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=chief', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'shape=Xxxxxxx', tag: 'B-LOC', weight: 2.827, value: 0 },
					{ feature: 'lowercase=partner', tag: 'O', weight: 0.621, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.68 },
					{ feature: 'word=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: -0.338, value: 0 },
					{ feature: 'lowercase=fast', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=chief', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'shape=Xxxxxxx', tag: 'B-LOC', weight: 2.827, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.569 },
					{ feature: 'word=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: -0.338, value: 0 },
					{ feature: 'lowercase=fast', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=chief', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'shape=Xxxxxxx', tag: 'B-LOC', weight: 2.827, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.55 },
					{ feature: 'word=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: -0.338, value: 0 },
					{ feature: 'lowercase=fast', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=chief', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'shape=Xxxxxxx', tag: 'B-LOC', weight: 2.827, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.598 },
					{ feature: 'word=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=on', tag: 'I-MISC', weight: -0.338, value: 0 },
					{ feature: 'lowercase=fast', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=chief', tag: 'O', weight: 0.78, value: 0 },
					{ feature: 'word=laying', tag: 'O', weight: 0.606, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.281,
				O: -1.988,
				'B-ORG': -3.826,
				'B-MISC': -4.878,
				'B-PER': -5.224,
				'B-LOC': -5.639,
			},
			z: 1.5,
			probabilities: {
				'I-MISC': 0.883,
				O: 0.091,
				'B-ORG': 0.015,
				'B-MISC': 0.005,
				'B-PER': 0.004,
				'B-LOC': 0.002,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.375 },
					{ feature: 'shape=Xxxxxx', tag: 'I-MISC', value: 1, weight: 0.232 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'word=flight', tag: 'O', weight: 0.696, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=first', tag: 'O', weight: 0.757, value: 0 },
					{ feature: 'shape=xxx', tag: 'O', weight: 0.339, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -2.653 },
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -1.442 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'word=Porsche', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=Newspapers', tag: 'O', weight: 3.553, value: 0 },
					{ feature: 'lowercase=open', tag: 'I-MISC', weight: 1.022, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: 1.342 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.569 },
					{ feature: 'word=Porsche', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'word=flight', tag: 'O', weight: 0.696, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=first', tag: 'O', weight: 0.757, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 1.546 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.55 },
					{ feature: 'word=Porsche', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'word=flight', tag: 'O', weight: 0.696, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=first', tag: 'O', weight: 0.757, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.68 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.086 },
					{ feature: 'word=Porsche', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'word=flight', tag: 'O', weight: 0.696, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=first', tag: 'O', weight: 0.757, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.598 },
					{ feature: 'word=Porsche', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'word=flight', tag: 'O', weight: 0.696, value: 0 },
					{ feature: 'lowercase=that', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=first', tag: 'O', weight: 0.757, value: 0 },
					{ feature: 'shape=xxx', tag: 'O', weight: 0.339, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.513,
				O: -3.429,
				'B-MISC': -3.536,
				'B-PER': -3.678,
				'B-ORG': -3.739,
				'B-LOC': -5.639,
			},
			z: 1.784,
			probabilities: {
				'I-MISC': 0.936,
				O: 0.018,
				'B-MISC': 0.016,
				'B-PER': 0.014,
				'B-ORG': 0.013,
				'B-LOC': 0.002,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'is_title_case', tag: 'I-MISC', value: 1, weight: 0.375 },
					{ feature: 'shape=Xxxxxxxx', tag: 'I-MISC', value: 1, weight: 0.372 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'lowercase=lows', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'word=and', tag: 'I-MISC', weight: -0.142, value: 0 },
					{ feature: 'word=Tennis', tag: 'I-MISC', weight: 0.79, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -2.653 },
					{ feature: 'shape=Xxxxxxxx', tag: 'O', value: 1, weight: -0.756 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.9, value: 0 },
					{ feature: 'lowercase=boards', tag: 'I-MISC', weight: 0.659, value: 0 },
					{ feature: 'word=Day', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: -0.68 },
					{ feature: 'lowercase=lows', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.9, value: 0 },
					{ feature: 'lowercase=boards', tag: 'I-MISC', weight: 0.659, value: 0 },
					{ feature: 'word=Day', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.569 },
					{ feature: 'lowercase=lows', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.9, value: 0 },
					{ feature: 'lowercase=boards', tag: 'I-MISC', weight: 0.659, value: 0 },
					{ feature: 'word=Day', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.55 },
					{ feature: 'lowercase=lows', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.9, value: 0 },
					{ feature: 'lowercase=boards', tag: 'I-MISC', weight: 0.659, value: 0 },
					{ feature: 'word=Day', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=South', tag: 'B-LOC', weight: 4.434, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.598 },
					{ feature: 'lowercase=lows', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=championship', tag: 'I-MISC', weight: 0.9, value: 0 },
					{ feature: 'lowercase=boards', tag: 'I-MISC', weight: 0.659, value: 0 },
					{ feature: 'word=Day', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=Lyngby', tag: 'B-ORG', weight: 4.012, value: 0 },
				],
			},
			sums: {
				'I-MISC': 0.652,
				O: -2.744,
				'B-ORG': -3.826,
				'B-MISC': -4.878,
				'B-PER': -5.224,
				'B-LOC': -5.639,
			},
			z: 2.022,
			probabilities: {
				'I-MISC': 0.949,
				O: 0.032,
				'B-ORG': 0.011,
				'B-MISC': 0.004,
				'B-PER': 0.003,
				'B-LOC': 0.002,
			},
		},
		{
			features: {
				'I-MISC': [
					{ feature: 'word=convention', tag: 'I-MISC', value: 1, weight: 2.91 },
					{ feature: 'shape=xxxxxxxxxx', tag: 'I-MISC', value: 1, weight: -1.325 },
					{ feature: 'lowercase=convention', tag: 'I-MISC', value: 1, weight: 1.072 },
					{ feature: 'is_not_title_case', tag: 'I-MISC', value: 1, weight: -0.552 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'word=laureate', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'word=Grand', tag: 'I-MISC', weight: 0.933, value: 0 },
				],
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.378 },
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.35 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'lowercase=parrots', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'lowercase=1:46', tag: 'O', weight: 0.781, value: 0 },
					{ feature: 'lowercase=champion', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=campaign', tag: 'O', weight: 0.6, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -2.096 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'word=laureate', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=parrots', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'lowercase=1:46', tag: 'O', weight: 0.781, value: 0 },
					{ feature: 'lowercase=champion', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=campaign', tag: 'O', weight: 0.6, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'word=laureate', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=parrots', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'lowercase=1:46', tag: 'O', weight: 0.781, value: 0 },
					{ feature: 'lowercase=champion', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=campaign', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'shape=d:dd', tag: 'O', weight: 0.781, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'word=laureate', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=parrots', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'lowercase=1:46', tag: 'O', weight: 0.781, value: 0 },
					{ feature: 'lowercase=champion', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=campaign', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'shape=d:dd', tag: 'O', weight: 0.781, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'word=laureate', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=parrots', tag: 'I-MISC', weight: 0.731, value: 0 },
					{ feature: 'lowercase=1:46', tag: 'O', weight: 0.781, value: 0 },
					{ feature: 'lowercase=champion', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'lowercase=campaign', tag: 'O', weight: 0.6, value: 0 },
					{ feature: 'shape=d:dd', tag: 'O', weight: 0.781, value: 0 },
				],
			},
			sums: {
				'I-MISC': 2.01,
				O: 1.393,
				'B-ORG': -5.241,
				'B-MISC': -5.447,
				'B-PER': -5.774,
				'B-LOC': -6.237,
			},
			z: 11.505,
			probabilities: {
				'I-MISC': 0.649,
				O: 0.35,
				'B-ORG': 0,
				'B-MISC': 0,
				'B-PER': 0,
				'B-LOC': 0,
			},
		},
		{
			features: {
				O: [
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.378 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.337 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.328 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.287 },
					{ feature: 'lowercase=miss', tag: 'B-ORG', weight: 3.808, value: 0 },
					{ feature: 'lowercase=war', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=OF', tag: 'I-MISC', weight: 0.377, value: 0 },
					{ feature: 'lowercase=camp', tag: 'O', weight: 0.778, value: 0 },
				],
				'I-MISC': [
					{ feature: 'is_not_title_case', tag: 'I-MISC', value: 1, weight: -0.552 },
					{ feature: 'is_not_uppercase', tag: 'I-MISC', value: 1, weight: -0.07 },
					{ feature: 'shape=xx', tag: 'I-MISC', value: 1, weight: 0.041 },
					{ feature: 'is_not_digit', tag: 'I-MISC', value: 1, weight: -0.025 },
					{ feature: 'lowercase=related', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'lowercase=miss', tag: 'B-ORG', weight: 3.808, value: 0 },
					{ feature: 'lowercase=supporters', tag: 'O', weight: 0.603, value: 0 },
					{ feature: 'word=and', tag: 'O', weight: 0.44, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -2.096 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.768 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -1.377 },
					{ feature: 'lowercase=related', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'lowercase=war', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=OF', tag: 'I-MISC', weight: 0.377, value: 0 },
					{ feature: 'lowercase=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', weight: 1.966, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -3.328 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -2.119 },
					{ feature: 'lowercase=related', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'lowercase=miss', tag: 'B-ORG', weight: 3.808, value: 0 },
					{ feature: 'lowercase=war', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=OF', tag: 'I-MISC', weight: 0.377, value: 0 },
					{ feature: 'lowercase=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'lowercase=sedan', tag: 'O', weight: 0.78, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -3.542 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -2.232 },
					{ feature: 'lowercase=related', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'lowercase=miss', tag: 'B-ORG', weight: 3.808, value: 0 },
					{ feature: 'lowercase=war', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=OF', tag: 'I-MISC', weight: 0.377, value: 0 },
					{ feature: 'lowercase=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', weight: 1.966, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -3.846 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -2.391 },
					{ feature: 'lowercase=related', tag: 'O', weight: 0.621, value: 0 },
					{ feature: 'lowercase=miss', tag: 'B-ORG', weight: 3.808, value: 0 },
					{ feature: 'lowercase=war', tag: 'I-MISC', weight: 0.746, value: 0 },
					{ feature: 'word=OF', tag: 'I-MISC', weight: 0.377, value: 0 },
					{ feature: 'lowercase=camp', tag: 'O', weight: 0.778, value: 0 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', weight: 1.966, value: 0 },
				],
			},
			sums: {
				O: 1.33,
				'I-MISC': -0.606,
				'B-ORG': -5.241,
				'B-MISC': -5.447,
				'B-PER': -5.774,
				'B-LOC': -6.237,
			},
			z: 4.341,
			probabilities: {
				O: 0.871,
				'I-MISC': 0.126,
				'B-ORG': 0.001,
				'B-MISC': 0.001,
				'B-PER': 0.001,
				'B-LOC': 0,
			},
		},
	],
	[
		{
			features: {
				'B-LOC': [
					{ feature: 'lowercase=czech', tag: 'B-LOC', value: 1, weight: 1.208 },
					{ feature: 'word=Czech', tag: 'B-LOC', value: 1, weight: 1.193 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 0.281 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.217 },
					{ feature: 'word=win', tag: 'O', weight: 0.439, value: 0 },
					{ feature: 'lowercase=pour', tag: 'O', weight: 0.424, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'lowercase=czech', tag: 'B-MISC', value: 1, weight: 0.821 },
					{ feature: 'word=Czech', tag: 'B-MISC', value: 1, weight: 0.457 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.167 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: 0.048 },
					{ feature: 'word=win', tag: 'O', weight: 0.439, value: 0 },
					{ feature: 'lowercase=johannesburg', tag: 'B-LOC', weight: 2.093, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'shape=Xxxxx', tag: 'B-PER', value: 1, weight: 0.368 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.187 },
					{ feature: 'word=win', tag: 'O', weight: 0.439, value: 0 },
					{ feature: 'lowercase=johannesburg', tag: 'B-LOC', weight: 2.093, value: 0 },
					{ feature: 'lowercase=notts', tag: 'B-ORG', weight: 2.541, value: 0 },
					{ feature: 'word=Dfl', tag: 'B-MISC', weight: 3.258, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.477 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.458 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'lowercase=johannesburg', tag: 'B-LOC', weight: 2.093, value: 0 },
					{ feature: 'lowercase=notts', tag: 'B-ORG', weight: 2.541, value: 0 },
					{ feature: 'word=Dfl', tag: 'B-MISC', weight: 3.258, value: 0 },
					{ feature: 'word=Arafat', tag: 'B-PER', weight: 2.103, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'lowercase=czech', tag: 'B-ORG', value: 1, weight: -0.506 },
					{ feature: 'word=Czech', tag: 'B-ORG', value: 1, weight: -0.364 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.251 },
					{ feature: 'shape=Xxxxx', tag: 'B-ORG', value: 1, weight: 0.113 },
					{ feature: 'word=win', tag: 'O', weight: 0.439, value: 0 },
					{ feature: 'lowercase=johannesburg', tag: 'B-LOC', weight: 2.093, value: 0 },
				],
			},
			sums: {
				'B-LOC': 1.734,
				'B-MISC': -0.439,
				'B-PER': -0.48,
				O: -1.404,
				'B-ORG': -2.263,
			},
			z: 7.276,
			probabilities: {
				'B-LOC': 0.778,
				'B-MISC': 0.089,
				'B-PER': 0.085,
				O: 0.034,
				'B-ORG': 0.014,
			},
		},
		{
			features: {
				'B-LOC': [
					{ feature: 'lowercase=boston', tag: 'B-LOC', value: 1, weight: 1.649 },
					{ feature: 'word=Boston', tag: 'B-LOC', value: 1, weight: 0.978 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'shape=Xxxxxx', tag: 'B-LOC', value: 1, weight: 0.381 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.217 },
					{ feature: 'word=closely-watched', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=Norihiko', tag: 'B-PER', weight: 2.339, value: 0 },
				],
				'B-ORG': [
					{ feature: 'word=Boston', tag: 'B-ORG', value: 1, weight: 1.405 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'lowercase=boston', tag: 'B-ORG', value: 1, weight: 0.922 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.251 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.224 },
					{ feature: 'word=closely-watched', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=Norihiko', tag: 'B-PER', weight: 2.339, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -0.633 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.458 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'word=Norihiko', tag: 'B-PER', weight: 2.339, value: 0 },
					{ feature: 'lowercase=paralympic', tag: 'B-MISC', weight: 2.387, value: 0 },
					{ feature: 'lowercase=newbury', tag: 'B-LOC', weight: 1.985, value: 0 },
					{ feature: 'lowercase=torino', tag: 'B-ORG', weight: 2.59, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 0.217 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.187 },
					{ feature: 'word=closely-watched', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'lowercase=paralympic', tag: 'B-MISC', weight: 2.387, value: 0 },
					{ feature: 'lowercase=newbury', tag: 'B-LOC', weight: 1.985, value: 0 },
					{ feature: 'lowercase=torino', tag: 'B-ORG', weight: 2.59, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.167 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: 0.043 },
					{ feature: 'word=closely-watched', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=Norihiko', tag: 'B-PER', weight: 2.339, value: 0 },
					{ feature: 'lowercase=newbury', tag: 'B-LOC', weight: 1.985, value: 0 },
					{ feature: 'lowercase=torino', tag: 'B-ORG', weight: 2.59, value: 0 },
				],
			},
			sums: {
				'B-LOC': 2.06,
				'B-ORG': 1.046,
				O: -0.559,
				'B-PER': -0.631,
				'B-MISC': -1.721,
			},
			z: 11.975,
			probabilities: {
				'B-LOC': 0.655,
				'B-ORG': 0.238,
				O: 0.048,
				'B-PER': 0.044,
				'B-MISC': 0.015,
			},
		},
		{
			features: {
				'B-PER': [
					{ feature: 'word=Geoff', tag: 'B-PER', value: 1, weight: 1.299 },
					{ feature: 'lowercase=geoff', tag: 'B-PER', value: 1, weight: 1.299 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'shape=Xxxxx', tag: 'B-PER', value: 1, weight: 0.368 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.187 },
					{ feature: 'word=street', tag: 'O', weight: 0.444, value: 0 },
					{ feature: 'word=Honda', tag: 'B-ORG', weight: 2.541, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'shape=Xxxxx', tag: 'B-LOC', value: 1, weight: 0.281 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.217 },
					{ feature: 'word=J.S.', tag: 'B-PER', weight: 3.369, value: 0 },
					{ feature: 'word=street', tag: 'O', weight: 0.444, value: 0 },
					{ feature: 'word=Honda', tag: 'B-ORG', weight: 2.541, value: 0 },
					{ feature: 'lowercase=overtook', tag: 'O', weight: 0.427, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.251 },
					{ feature: 'shape=Xxxxx', tag: 'B-ORG', value: 1, weight: 0.113 },
					{ feature: 'word=J.S.', tag: 'B-PER', weight: 3.369, value: 0 },
					{ feature: 'word=street', tag: 'O', weight: 0.444, value: 0 },
					{ feature: 'word=Sandrine', tag: 'B-PER', weight: 2.339, value: 0 },
					{ feature: 'lowercase=conakry', tag: 'B-LOC', weight: 1.985, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxx', tag: 'O', value: 1, weight: -1.477 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.458 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'word=J.S.', tag: 'B-PER', weight: 3.369, value: 0 },
					{ feature: 'word=Honda', tag: 'B-ORG', weight: 2.541, value: 0 },
					{ feature: 'lowercase=conakry', tag: 'B-LOC', weight: 1.985, value: 0 },
					{ feature: 'lowercase=near', tag: 'B-MISC', weight: 0.961, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.167 },
					{ feature: 'shape=Xxxxx', tag: 'B-MISC', value: 1, weight: 0.048 },
					{ feature: 'word=J.S.', tag: 'B-PER', weight: 3.369, value: 0 },
					{ feature: 'word=street', tag: 'O', weight: 0.444, value: 0 },
					{ feature: 'word=Honda', tag: 'B-ORG', weight: 2.541, value: 0 },
					{ feature: 'lowercase=conakry', tag: 'B-LOC', weight: 1.985, value: 0 },
				],
			},
			sums: {
				'B-PER': 2.117,
				'B-LOC': -0.667,
				'B-ORG': -1.392,
				O: -1.404,
				'B-MISC': -1.717,
			},
			z: 9.493,
			probabilities: {
				'B-PER': 0.875,
				'B-LOC': 0.054,
				'B-ORG': 0.026,
				O: 0.026,
				'B-MISC': 0.019,
			},
		},
		{
			features: {
				'B-ORG': [
					{ feature: 'word=St.', tag: 'B-ORG', value: 1, weight: 1.246 },
					{ feature: 'lowercase=st.', tag: 'B-ORG', value: 1, weight: 1.246 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'shape=Xx.', tag: 'B-ORG', value: 1, weight: 0.907 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.251 },
					{ feature: 'lowercase=harassment', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=8-10', tag: 'O', weight: 0.447, value: 0 },
				],
				'B-LOC': [
					{ feature: 'word=St.', tag: 'B-LOC', value: 1, weight: 1.041 },
					{ feature: 'lowercase=st.', tag: 'B-LOC', value: 1, weight: 1.041 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'shape=Xx.', tag: 'B-LOC', value: 1, weight: 0.579 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.217 },
					{ feature: 'lowercase=harassment', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=8-10', tag: 'O', weight: 0.447, value: 0 },
				],
				O: [
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.458 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'shape=Xx.', tag: 'O', value: 1, weight: -0.024 },
					{ feature: 'word=madness', tag: 'O', weight: 0.437, value: 0 },
					{ feature: 'word=Arkadiusz', tag: 'B-PER', weight: 2.434, value: 0 },
					{ feature: 'lowercase=chamber', tag: 'B-ORG', weight: 2.227, value: 0 },
					{ feature: 'word=Finn', tag: 'B-MISC', weight: 2.963, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.187 },
					{ feature: 'lowercase=harassment', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=8-10', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'lowercase=chamber', tag: 'B-ORG', weight: 2.227, value: 0 },
					{ feature: 'word=Finn', tag: 'B-MISC', weight: 2.963, value: 0 },
					{ feature: 'word=Suleimaniya', tag: 'B-LOC', weight: 1.795, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.167 },
					{ feature: 'lowercase=harassment', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=8-10', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'word=Arkadiusz', tag: 'B-PER', weight: 2.434, value: 0 },
					{ feature: 'lowercase=chamber', tag: 'B-ORG', weight: 2.227, value: 0 },
					{ feature: 'word=Suleimaniya', tag: 'B-LOC', weight: 1.795, value: 0 },
				],
			},
			sums: {
				'B-ORG': 1.894,
				'B-LOC': 1.713,
				O: 0.05,
				'B-PER': -0.848,
				'B-MISC': -1.764,
			},
			z: 13.842,
			probabilities: {
				'B-ORG': 0.48,
				'B-LOC': 0.401,
				O: 0.076,
				'B-PER': 0.031,
				'B-MISC': 0.012,
			},
		},
		{
			features: {
				'B-ORG': [
					{ feature: 'word=Senate', tag: 'B-ORG', value: 1, weight: 1.795 },
					{ feature: 'lowercase=senate', tag: 'B-ORG', value: 1, weight: 1.795 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.251 },
					{ feature: 'shape=Xxxxxx', tag: 'B-ORG', value: 1, weight: 0.224 },
					{ feature: 'lowercase=pembroke', tag: 'B-LOC', weight: 2.247, value: 0 },
					{ feature: 'word=roads', tag: 'O', weight: 0.427, value: 0 },
				],
				O: [
					{ feature: 'shape=Xxxxxx', tag: 'O', value: 1, weight: -0.633 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.458 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'lowercase=pembroke', tag: 'B-LOC', weight: 2.247, value: 0 },
					{ feature: 'lowercase=ruxandra', tag: 'B-PER', weight: 2.339, value: 0 },
					{ feature: 'lowercase=berkshire', tag: 'B-ORG', weight: 2.445, value: 0 },
					{
						feature: 'lowercase=communist-led',
						tag: 'B-MISC',
						weight: 3.504,
						value: 0,
					},
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'shape=Xxxxxx', tag: 'B-LOC', value: 1, weight: 0.381 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.217 },
					{ feature: 'word=roads', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=ruxandra', tag: 'B-PER', weight: 2.339, value: 0 },
					{ feature: 'lowercase=berkshire', tag: 'B-ORG', weight: 2.445, value: 0 },
					{
						feature: 'lowercase=communist-led',
						tag: 'B-MISC',
						weight: 3.504,
						value: 0,
					},
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'shape=Xxxxxx', tag: 'B-PER', value: 1, weight: 0.217 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.187 },
					{ feature: 'lowercase=pembroke', tag: 'B-LOC', weight: 2.247, value: 0 },
					{ feature: 'word=roads', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=berkshire', tag: 'B-ORG', weight: 2.445, value: 0 },
					{
						feature: 'lowercase=communist-led',
						tag: 'B-MISC',
						weight: 3.504,
						value: 0,
					},
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.167 },
					{ feature: 'shape=Xxxxxx', tag: 'B-MISC', value: 1, weight: 0.043 },
					{ feature: 'lowercase=pembroke', tag: 'B-LOC', weight: 2.247, value: 0 },
					{ feature: 'word=roads', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=ruxandra', tag: 'B-PER', weight: 2.339, value: 0 },
					{ feature: 'lowercase=berkshire', tag: 'B-ORG', weight: 2.445, value: 0 },
				],
			},
			sums: {
				'B-ORG': 2.309,
				O: -0.559,
				'B-LOC': -0.567,
				'B-PER': -0.631,
				'B-MISC': -1.721,
			},
			z: 11.914,
			probabilities: {
				'B-ORG': 0.845,
				O: 0.048,
				'B-LOC': 0.048,
				'B-PER': 0.045,
				'B-MISC': 0.015,
			},
		},
		{
			features: {
				'B-ORG': [
					{ feature: 'lowercase=interior', tag: 'B-ORG', value: 1, weight: 2.057 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'word=Interior', tag: 'B-ORG', value: 1, weight: 0.438 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-ORG', value: 1, weight: 0.407 },
					{ feature: 'is_title_case', tag: 'B-ORG', value: 1, weight: 0.251 },
					{ feature: 'lowercase=staff', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=mo', tag: 'B-LOC', weight: 2.639, value: 0 },
				],
				O: [
					{ feature: 'word=Interior', tag: 'O', value: 1, weight: 1.785 },
					{ feature: 'lowercase=interior', tag: 'O', value: 1, weight: -0.497 },
					{ feature: 'is_title_case', tag: 'O', value: 1, weight: -0.458 },
					{ feature: 'shape=Xxxxxxxx', tag: 'O', value: 1, weight: -0.291 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'lowercase=mo', tag: 'B-LOC', weight: 2.639, value: 0 },
					{ feature: 'lowercase=ninth', tag: 'B-ORG', weight: 1.03, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'is_title_case', tag: 'B-LOC', value: 1, weight: 0.217 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-LOC', value: 1, weight: 0.171 },
					{ feature: 'lowercase=staff', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=ninth', tag: 'B-ORG', weight: 1.03, value: 0 },
					{ feature: 'word=Lynch', tag: 'B-PER', weight: 1.873, value: 0 },
					{ feature: 'word=downgraded', tag: 'O', weight: 0.447, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'is_title_case', tag: 'B-PER', value: 1, weight: 0.187 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-PER', value: 1, weight: -0.098 },
					{ feature: 'lowercase=staff', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=mo', tag: 'B-LOC', weight: 2.639, value: 0 },
					{ feature: 'lowercase=ninth', tag: 'B-ORG', weight: 1.03, value: 0 },
					{ feature: 'shape=xxx-xx-xxxxxx', tag: 'O', weight: 0.447, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'shape=Xxxxxxxx', tag: 'B-MISC', value: 1, weight: 0.376 },
					{ feature: 'is_title_case', tag: 'B-MISC', value: 1, weight: 0.167 },
					{ feature: 'lowercase=staff', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=mo', tag: 'B-LOC', weight: 2.639, value: 0 },
					{ feature: 'lowercase=ninth', tag: 'B-ORG', weight: 1.03, value: 0 },
					{ feature: 'word=Lynch', tag: 'B-PER', weight: 1.873, value: 0 },
				],
			},
			sums: {
				'B-ORG': 1.397,
				O: 1.071,
				'B-LOC': -0.777,
				'B-PER': -0.946,
				'B-MISC': -1.389,
			},
			z: 8.059,
			probabilities: {
				'B-ORG': 0.502,
				O: 0.362,
				'B-LOC': 0.057,
				'B-PER': 0.048,
				'B-MISC': 0.031,
			},
		},
		{
			features: {
				O: [
					{ feature: 'shape=xxxxxxxxxx', tag: 'O', value: 1, weight: 0.31 },
					{ feature: 'word=convention', tag: 'O', value: 1, weight: 0.31 },
					{ feature: 'lowercase=convention', tag: 'O', value: 1, weight: 0.31 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.291 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'lowercase=f.h.', tag: 'B-ORG', weight: 1.839, value: 0 },
					{ feature: 'lowercase=jadeja', tag: 'B-PER', weight: 2.103, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -2.697 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'word=dirty', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=jadeja', tag: 'B-PER', weight: 2.103, value: 0 },
					{ feature: 'lowercase=than', tag: 'O', weight: 0.424, value: 0 },
					{ feature: 'lowercase=phnom', tag: 'B-LOC', weight: 2.012, value: 0 },
					{ feature: 'word=require', tag: 'O', weight: 0.437, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -3.07 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'word=dirty', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=f.h.', tag: 'B-ORG', weight: 1.839, value: 0 },
					{ feature: 'lowercase=jadeja', tag: 'B-PER', weight: 2.103, value: 0 },
					{ feature: 'lowercase=than', tag: 'O', weight: 0.424, value: 0 },
					{ feature: 'lowercase=phnom', tag: 'B-LOC', weight: 2.012, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -4.304 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'word=dirty', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=f.h.', tag: 'B-ORG', weight: 1.839, value: 0 },
					{ feature: 'lowercase=jadeja', tag: 'B-PER', weight: 2.103, value: 0 },
					{ feature: 'lowercase=than', tag: 'O', weight: 0.424, value: 0 },
					{ feature: 'lowercase=50.14', tag: 'O', weight: 0.447, value: 0 },
				],
				'B-PER': [
					{ feature: 'is_not_title_case', tag: 'B-PER', value: 1, weight: -4.817 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'word=dirty', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=f.h.', tag: 'B-ORG', weight: 1.839, value: 0 },
					{ feature: 'word=sectors', tag: 'O', weight: 0.437, value: 0 },
					{ feature: 'lowercase=phnom', tag: 'B-LOC', weight: 2.012, value: 0 },
					{ feature: 'word=require', tag: 'O', weight: 0.437, value: 0 },
				],
			},
			sums: {
				O: 1.752,
				'B-ORG': -4.453,
				'B-MISC': -5.001,
				'B-LOC': -5.469,
				'B-PER': -5.852,
			},
			z: 5.792,
			probabilities: {
				O: 0.996,
				'B-ORG': 0.002,
				'B-MISC': 0.001,
				'B-LOC': 0.001,
				'B-PER': 0,
			},
		},
		{
			features: {
				O: [
					{ feature: 'lowercase=de', tag: 'O', value: 1, weight: -0.82 },
					{ feature: 'word=de', tag: 'O', value: 1, weight: -0.712 },
					{ feature: 'shape=xx', tag: 'O', value: 1, weight: 0.302 },
					{ feature: 'is_not_title_case', tag: 'O', value: 1, weight: 0.291 },
					{ feature: 'is_not_uppercase', tag: 'O', value: 1, weight: 0.271 },
					{ feature: 'is_not_digit', tag: 'O', value: 1, weight: 0.261 },
					{ feature: 'lowercase=popular', tag: 'B-ORG', weight: 2.195, value: 0 },
					{
						feature: 'lowercase=franco-prussian',
						tag: 'B-MISC',
						weight: 2.19,
						value: 0,
					},
				],
				'B-PER': [
					{ feature: 'is_not_title_case', tag: 'B-PER', value: 1, weight: -4.817 },
					{ feature: 'word=de', tag: 'B-PER', value: 1, weight: 4.7 },
					{ feature: 'lowercase=de', tag: 'B-PER', value: 1, weight: 2.893 },
					{ feature: 'shape=xx', tag: 'B-PER', value: 1, weight: -2.677 },
					{ feature: 'is_not_uppercase', tag: 'B-PER', value: 1, weight: -0.567 },
					{ feature: 'is_not_digit', tag: 'B-PER', value: 1, weight: -0.468 },
					{ feature: 'word=shown', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=popular', tag: 'B-ORG', weight: 2.195, value: 0 },
				],
				'B-ORG': [
					{ feature: 'is_not_title_case', tag: 'B-ORG', value: 1, weight: -2.697 },
					{ feature: 'is_not_uppercase', tag: 'B-ORG', value: 1, weight: -1.016 },
					{ feature: 'is_not_digit', tag: 'B-ORG', value: 1, weight: -0.74 },
					{ feature: 'word=shown', tag: 'O', weight: 0.427, value: 0 },
					{
						feature: 'lowercase=franco-prussian',
						tag: 'B-MISC',
						weight: 2.19,
						value: 0,
					},
					{ feature: 'lowercase=heath', tag: 'B-PER', weight: 1.873, value: 0 },
					{ feature: 'word=appearing', tag: 'O', weight: 0.447, value: 0 },
					{ feature: 'lowercase=shipment', tag: 'O', weight: 0.427, value: 0 },
				],
				'B-MISC': [
					{ feature: 'is_not_title_case', tag: 'B-MISC', value: 1, weight: -3.07 },
					{ feature: 'is_not_uppercase', tag: 'B-MISC', value: 1, weight: -1.069 },
					{ feature: 'is_not_digit', tag: 'B-MISC', value: 1, weight: -0.862 },
					{ feature: 'word=shown', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=popular', tag: 'B-ORG', weight: 2.195, value: 0 },
					{ feature: 'word=Doubletree', tag: 'B-ORG', weight: 2.11, value: 0 },
					{ feature: 'lowercase=heath', tag: 'B-PER', weight: 1.873, value: 0 },
					{ feature: 'word=appearing', tag: 'O', weight: 0.447, value: 0 },
				],
				'B-LOC': [
					{ feature: 'is_not_title_case', tag: 'B-LOC', value: 1, weight: -4.304 },
					{ feature: 'is_not_uppercase', tag: 'B-LOC', value: 1, weight: -0.643 },
					{ feature: 'is_not_digit', tag: 'B-LOC', value: 1, weight: -0.522 },
					{ feature: 'word=shown', tag: 'O', weight: 0.427, value: 0 },
					{ feature: 'lowercase=popular', tag: 'B-ORG', weight: 2.195, value: 0 },
					{
						feature: 'lowercase=franco-prussian',
						tag: 'B-MISC',
						weight: 2.19,
						value: 0,
					},
					{ feature: 'lowercase=heath', tag: 'B-PER', weight: 1.873, value: 0 },
					{ feature: 'word=appearing', tag: 'O', weight: 0.447, value: 0 },
				],
			},
			sums: {
				O: -0.409,
				'B-PER': -0.935,
				'B-ORG': -4.453,
				'B-MISC': -5.001,
				'B-LOC': -5.469,
			},
			z: 1.079,
			probabilities: {
				O: 0.616,
				'B-PER': 0.364,
				'B-ORG': 0.011,
				'B-MISC': 0.006,
				'B-LOC': 0.004,
			},
		},
	],
]
