---
name: "[Tech Chair] Deployment to Production Checklist"
about: Checklist for Tech Chair to deploy an accepted paper
title: "[PUBLICATION] Deployment to Production Checklist"
labels:
assignees:
---

<!--
## DO NOT EDIT THIS FILE OUTSIDE OF THE journalovi/jovi-workflows REPOSITORY
##
## This file is automatically updated in all repositories within the journalovi
## Github organization whenever the version in journalovi/jovi-workflows is
## changed, so any other edits will be overwritten. To update this file, make
## a commit or pull request at https://github.com/journalovi/jovi-workflows
-->

# THIS ISSUE TEMPLATE IS A WORK IN PROGRESS STUB.


### Setup memo

- [ ] Clone the [`jovi-workflows` repo](https://github.com/journalovi/jovi-workflows).
- [ ] Install required Python dependencies, when needed. At the time of writing: `pip install json requests markdown2`
- [ ] To use the GitHub API you need a "Personal Access Token". See the [README](https://github.com/journalovi/jovi-workflows/blob/aa63456baeec65e44862ce71fd4e904bdef6b355/README.md) about how to get it.

> [!IMPORTANT]
> Do not share your token. Never commit your token to the repo or send it to anyone.

- [ ] Replace `<YOUR_TOKEN_HERE>` or `JOVI_COMMIT_TOKEN` with your token in the python scripts that you run locally. `jovi-git-snapshot.py`
- [ ] Install [`wkhtmltopdf`](https://wkhtmltopdf.org/downloads.html).

> [!TIP]
> On windows when running the Python scripts, you may run into "Filename too long" errors. Setting `git config --global core.longpaths true` worked for me. [Reference](https://support.atlassian.com/bamboo/kb/git-checkouts-fail-on-windows-with-filename-too-long-error-unable-to-create-file-errors/).


### The checklist

- [ ] Create snapshot of paper metadata
  - [ ] Run [`jovi-git-snapshot.py <2025-author-XYZ>`](https://github.com/journalovi/jovi_snapshot/blob/main/jovi-git-snapshot.py) (replace `XYZ`). This will clone the repo and commit the `metadata.json` file.
  - [ ] Check that the metadata file was created and committed. `git -C "journalovi/2025-author-XYZ" status` should show: `Your branch is ahead of 'origin/main' by 1 commit`.
  - [ ] Run [`jovi-git-reviews.py <2025-author-XYZ>`](https://github.com/journalovi/jovi_snapshot/blob/main/jovi-git-reviews.py). This script creates html and pdfs of the reviews.
  - [ ] Check that the metadata file was created and committed. `git -C "journalovi/2025-author-XYZ" status -u` should show a new html and pdf file for each review.
  - [ ] ...TODO keep going!
