---
name: "[Tech Chair] Infrastructure Setup Checklist"
about: Checklist for Tech chair to fill out to set up repository
title: "[PRE-REVIEW] Infrastructure Setup Checklist"
labels: pre-review
assignees: ''
---

<!--
## DO NOT EDIT THIS FILE OUTSIDE OF THE journalovi/jovi-workflows REPOSITORY
##
## This file is automatically updated in all repositories within the journalovi
## Github organization whenever the version in journalovi/jovi-workflows is
## changed, so any other edits will be overwritten. To update this file, make
## a commit or pull request at https://github.com/journalovi/jovi-workflows
-->

*Delete any checkboxes that do not apply to this paper*

- [ ] Add submission to the internal JoVI submissions spreadsheet
- [ ] Set up Github pages
   - [ ] If the paper is static HTML and does not require compilation:
      - [ ] ensure the paper contents are in `index.html` in the root folder of the repository
      - [ ] Go to **Settings -> Pages**:
         - [ ] Set "Source" to "Deploy from a branch"
         - [ ] Set "Branch" to "main" (or "master")
         - [ ] Set the folder to "/"
   - [ ] If the paper requires compilation:
      - [ ] Ensure it has a workflow file, such as `.github/workflows/publish.yml`, that compiles the paper and copies the compiled result to the root folder of the `gh-pages` branch. Some example workflow files:
         - [Quarto](https://github.com/journalovi/jovi-template-quarto/blob/main/.github/workflows/publish.yml)
         - [Idyll](https://github.com/journalovi/2024-Cashman-PAC-learning-game/blob/master/.github/workflows/publish.yml) - this template can be easily adapted for other workflows that use custom tools for building, e.g. npm or yarn, by swapping out the `npm` commands and ensuring the correct output folder is copied to the `gh-pages` branch in the last step.
      - [ ] Go to **Settings -> Pages**:
         - [ ] Set "Source" to "Deploy from a branch"
         - [ ] Set "Branch" to "gh-pages"
         - [ ] Set the folder to "/"
      - [ ] Verify the compilation works. On the repo page, go to Actions and click on the "XXX Publish" (XXX = Quarto/Idyll/etc) workflow on the left, then click Run Workflow and run it.
   - [ ] Verify that the "pages build and deployment" action is successful.
   - [ ] Check that the live version of the article is visible at http://www.journalovi.org/20XX-YY-ZZ (replace the last part with the repo name).
- [ ] Ensure the paper contains a notice infobox at the top that the paper is under review and that the repository links in the notice are correct (by replacing the `20xx-repo-name` part with the repository name).

   In Quarto this looks like:

   ```
   ::: {.callout-important appearance="simple"}
   ## Under Review {.unnumbered}
   This paper is [under review](https://www.journalovi.org/under-review.html) on the experimental
   track of the [Journal of Visualization and Interaction](https://www.journalovi.org/).
   See the [reviews](https://github.com/journalovi/20xx-repo-name/issues?q=label%3Areview) and
   [issues](https://github.com/journalovi/20xx-repo-name/issues) for this paper.
   :::
   ```

   In HTML this could be:

   ```
   <p style="border-left: 5px solid #ff4136; border-right: 1px solid #dee2e6; border-top: 1px solid #dee2e6; border-bottom: 1px solid #dee2e6; border-radius: 6px; padding: 0.75em 1em;">
   <strong>Under Review:</strong> This paper is <a href="https://www.journalovi.org/under-review.html">under review</a>
   on the experimental track of the <a href="https://www.journalovi.org/">Journal of Visualization and Interaction</a>.
   See the <a href="https://github.com/journalovi/20xx-repo-name/issues?q=label%3Areview">reviews</a> and
   <a href="https://github.com/journalovi/20xx-repo-name/issues">issues</a> for this paper.
   </p>
   ```
   - [ ] In the info box, ensure “20xx-repo-name” is replaced with the name of the repository so that the links point to the appropriate pages on Github.
   - [ ] Check that the live version of the paper now has the infobox in it with the correct links. You may need to go to the Actions page to check that the build process has completed, then go back to the live paper URL. You might need to reload the article without cache (In Chrome: Cmd + Shift + R (Mac) or Ctrl+ Shift + R (Windows)).
- [ ] Compare the paper with the authors’ compiled version that the authors submitted. Sample the figures and interactive elements to see if they are present and work in the same way.
- [ ] Check that the article works locally without an internet connection:
   - [ ] Check out the repo and switch to whatever branch serves the site (e.g. `main` or `master` for sites without compilation, `gh-pages` for sites with compilation).
   - [ ] Compare the page with internet on and internet off (e.g. in airplane mode), ensuring the page is the same. You may need to use a local server from the repo directory:
         
      ```sh
      python -m http.server
      ```

      When loading, keep the dev console open and note any resources that are unable to load. Sample the figures and interactive elements to see if they are present and work in the same way. If any are missing, either attempt to fix or prepare a list for the authors of resources they will need to ensure are included in their repository rather than loaded over the network. In quarto, it may be helpful to add (if it is not there already):

      ```yaml
      format:
        html:
          embed-resources: true
          self-contained-math: true
          html-math-method: katex
      ```
- [ ] From the [main repo page](../), click the settings gear icon next to "About" on the right. (If you cannot see the “About” section, make your web browser window wider.)
   - [ ] Under "Description" enter "UNDER REVIEW"
   - [ ] Under "Website" tick "Use Your Github Pages Website".
   - [ ] Click “Save changes”
- [ ] Edit README.md and add the following at the very top:
   ````
   ```diff
   ! This paper is under review on the experimental track of the Journal of Visualization and Interaction.
   Authors: [insert Github IDs]
   OC: TBD
   AE: TBD
   R1: TBD
   R2: TBD
   R3: TBD
   ```
   ````
- [ ] Replace `[insert Github IDs]` in `README.md` with the authors' Github IDs.
- [ ] When an OC has been assigned to this paper, replace the `TBD` under `OC:` in `README.md` with the Github ID of the OC.
- [ ] Enable branch protection on the repository:
   - [ ] Under Settings -> Branches, click "Add branch protection rule"
   - [ ] Under "Branch name pattern", enter "main" or "master" (whichever applies to this repo)
   - [ ] Click "Create"
   - [ ] Check that the newly-created rule says "Currently applies to 1 branch" next to it.
- [ ] Ensure that the authors have write access to the repo:
   - [ ] Under Settings -> Collaborators and Teams, click "Add people"
   - [ ] Enter the Github usernames for each author as provided by the authors. Give each one "Write" access.
- [ ] Re-render [under-review.qmd](https://github.com/journalovi/journalovi.github.io/blob/main/under-review.qmd) on the JoVI website (See instructions in the source code). Ensure that the added paper is listed on the [Under Review](https://www.journalovi.org/under-review.html) page in the correct location.
- [ ] When this checklist is complete, create the following issues and tag the relevant people (Github IDs are listed on [People page](https://www.journalovi.org/people.html)), then close this issue:
   - [ ] [Recruit Associate Editor](new?assignees=&labels=pre-review&projects=&template=91_tech_org-recruit_editor.md&title=%5BPRE-REVIEW%5D+Recruit+Associate+Editor) (assign to the OC of this paper) (**NOTE:** this part of the process may change as we evolve the Editor-Wrangler role)
   - [ ] [Open Materials Review](new?assignees=&labels=review&projects=&template=92_tech_open-review.md&title=%5BREVIEW%5D+Open+Materials+Review) (assign to the Open Practices Chair)
   - [ ] [Accessibility Review Request](new?assignees=&labels=pre-review&projects=&template=93_tech_acc-review_request.md&title=%5BPRE-REVIEW%5D+Accessibility+Review+Request) (assign to the Accessibility Chair)
